<?php

namespace App\General;

use Exception;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class DataGeneral {

    static function retirarFormatacaoSalario($valorFormatado) {
        // Remove os pontos de separação de milhar
        $valorSemPontos = str_replace('.', '', $valorFormatado);
    
        // Substitui a vírgula decimal por um ponto
        $valorNumerico = str_replace(',', '.', $valorSemPontos);
    
        return $valorNumerico;
    }

    public static function gerarCodigoDeAutenticacaoParaAlterarSenha() {
        //$codigosGerados = DB::select("SELECT u.codigoReset FROM `users` as u");
        $codigosGerados = DB::table('users')->pluck('codigoReset')->toArray();
        //dd($codigosGerados);
        do {
            $codigoNovo = rand(100000, 999999);
        } while (in_array($codigoNovo, $codigosGerados)); 
    
        return $codigoNovo;
    }

    public static function gerarDataExpiracaoDoCodigoRecuperacaoSenha($minutos) {
        $dataAtual = DB::selectOne("SELECT NOW() AS dataAtual")->dataAtual;
    
        $data = Carbon::parse($dataAtual);
        $data->addMinutes($minutos);
    
        return $data->format('Y-m-d H:i:s');
    }

    public static function dataHoraActual() {
        $dataAtual = DB::selectOne("SELECT NOW() AS dataAtual")->dataAtual;
    
        return Carbon::parse($dataAtual)->format('Y-m-d H:i:s');
    }
    
}
