<?php

namespace App\Http\Controllers;

use App\Models\AppConfig;
use App\Models\AuditoriaGeral;
use App\Models\EntidadeSys;
use Illuminate\Http\Request;

class AuditoriaGeralController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $logs = AuditoriaGeral::orderBy('created_at', 'desc')->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        return view('admin.auditoria.logsGerais.index', compact('logs', 'entidadeVisual'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $id = decrypt($id);
        $log = AuditoriaGeral::findOrFail($id);
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.auditoria.logsGerais.show', compact('log', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(AuditoriaGeral $auditoriaGeral)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, AuditoriaGeral $auditoriaGeral)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(AuditoriaGeral $auditoriaGeral)
    {
        //
    }
}
