<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreBeneficioRequest;
use App\Http\Requests\UpdateBeneficioRequest;
use App\Models\AppConfig;
use App\Models\Beneficio;
use App\Models\CategoriaBeneficio;
use App\Models\EntidadeSys;
use Exception;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\DB;

class BeneficioController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $beneficios = Beneficio::orderBy('created_at', 'desc')->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.beneficio.index', compact('beneficios', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        //
        $categoriasBeneficios = CategoriaBeneficio::where('estado', 1)->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.beneficio.create', compact('categoriasBeneficios', 'entidadeVisual', 'config'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreBeneficioRequest $request)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try{
                DB::beginTransaction();

                $beneficio = new Beneficio();
                $beneficio->nome = filter_var($request->beneficio, FILTER_SANITIZE_STRING);
                $beneficio->descricao = filter_var($request->descricao, FILTER_SANITIZE_STRING);
                $beneficio->categoria_id = filter_var($request->categoria, FILTER_SANITIZE_STRING);
                $beneficio->estado = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $beneficio->save();

                DB::commit();

                return redirect()->route('beneficio.index')->with('success', 'Benefiício registrado com sucesso!');

            }catch(Exception $error){
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao registrar o Benefiício!');
            }
        }else{
            return redirect()->route('admin');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $ID = decrypt($id);
        $beneficio = Beneficio::findOrFail($ID);
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.beneficio.show', compact('beneficio','entidadeVisual', 'config'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        //
        $ID = decrypt($id);
        $beneficio = Beneficio::findOrFail($ID);
        $categoriasBeneficios = CategoriaBeneficio::where('estado', 1)->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.beneficio.edit', compact('beneficio','categoriasBeneficios','entidadeVisual', 'config'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateBeneficioRequest $request, $id)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try {
                DB::beginTransaction();
                
                $ID = decrypt($id);
                $beneficio = Beneficio::findOrFail($ID); 

                $beneficio->nome = filter_var($request->beneficio, FILTER_SANITIZE_STRING);
                $beneficio->descricao = filter_var($request->descricao, FILTER_SANITIZE_STRING);
                $beneficio->categoria_id = filter_var($request->categoria, FILTER_SANITIZE_STRING);
                $beneficio->estado = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $beneficio->save();

                DB::commit();

                return redirect()->route('beneficio.index')->with('success', 'Benefício atualizado com sucesso!');
            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao atualizar O Benefício!');
            }
        } else {
            return redirect()->route('admin');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor')) {
            try {
                DB::beginTransaction();
                
                $ID = decrypt($id);
                $beneficio = Beneficio::findOrFail($ID);

                $beneficio->delete();
                DB::commit();

                return redirect()->route('beneficio.index')->with('success', 'Benefício excluído com sucesso.');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao excluír o Benefício!');
            }
        } else {
            return redirect()->route('admin');
        }
    }
}
