<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreBunnerRequest;
use App\Http\Requests\UpdateBunnerRequest;
use App\Models\AppConfig;
use App\Models\Bunner;
use App\Models\EntidadeSys;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Storage;

class BunnerController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $bunners = Bunner::all();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.configuracoes.entidade.bunner.index', compact('bunners', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.configuracoes.entidade.bunner.create', compact('entidadeVisual','config'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreBunnerRequest $request)
    {
        //
        $pathLogo = null;
        if (Gate::allows('isAdmin')) {
            try{
                DB::beginTransaction();

                if ($request->fixo == 1) {
                    $existeFixo = Bunner::where('isFixo', 1)->exists();

                    if ($existeFixo) {
                        return redirect()->back()->withErrors('Já existe um item registrado com a imagem fixa!');
                    }
                }

                if ($request->file('imagem') != null) {
                    $foto = $request->file('imagem');
                    $pathLogo = $foto->getClientOriginalName();
                    $foto->move(public_path("admin/endidadesIMG/bunnerSlide"), $pathLogo);
                }

                $item = new Bunner();
                $item->titulo = filter_var($request->titulo, FILTER_SANITIZE_STRING);
                $item->imagem = $pathLogo;;
                $item->cor_titulo = filter_var($request->cor, FILTER_SANITIZE_STRING);
                $item->isFixo = filter_var($request->fixo, FILTER_SANITIZE_STRING);
                $item->estado = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $item->save();

                DB::commit();

                return redirect()->route('bunner.index')->with('success', 'Item do Banner adicionado com sucesso.');

            }catch(Exception $error){
                DB::rollBack();
                dd($error);
                return redirect()->back()->withErrors('Falha ao registrar o item do banner!');
            }
        }else{
            return redirect()->route('admin');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $ID = decrypt($id);
        $bunner = Bunner::findOrFail($ID); 
        $config = AppConfig::current();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        return view('admin.configuracoes.entidade.bunner.show', compact('bunner', 'config', 'entidadeVisual'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        //
        $ID = decrypt($id);
        $bunner = Bunner::findOrFail($ID); 
        $config = AppConfig::current();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        return view('admin.configuracoes.entidade.bunner.edit', compact('bunner', 'config', 'entidadeVisual'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateBunnerRequest $request, $id)
    {
        //    
        if (Gate::allows('isAdmin')) {
            try{
                DB::beginTransaction();

                $ID = decrypt($id);
                $bunner = Bunner::findOrFail($ID); 
                $pathImagem = $bunner->imagem;

                if ($request->fixo == 1 && $bunner->isFixo != 1) {
                    $existeFixo = Bunner::where('isFixo', 1)
                                        ->where('id', '<>', $bunner->id)
                                        ->exists();

                    if ($existeFixo) {
                        return redirect()->back()
                            ->withErrors('Já existe um item registrado com a imagem fixa!');
                    }
                }

                if ($request->file('imagem') != null) {
                    if ($pathImagem && file_exists(public_path("admin/endidadesIMG/bunnerSlide/{$pathImagem}"))) {
                        unlink(public_path("admin/endidadesIMG/bunnerSlide/{$pathImagem}"));
                    }

                    $foto = $request->file('imagem');
                    $pathImagem = $foto->getClientOriginalName();
                    $foto->move(public_path("admin/endidadesIMG/bunnerSlide"), $pathImagem);
                }

                $bunner->titulo = filter_var($request->titulo, FILTER_SANITIZE_STRING);
                $bunner->imagem = $pathImagem;
                $bunner->cor_titulo = filter_var($request->cor, FILTER_SANITIZE_STRING);
                $bunner->isFixo = filter_var($request->fixo, FILTER_SANITIZE_STRING);
                $bunner->estado = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $bunner->save();

                DB::commit();
                return redirect()->route('bunner.index')->with('success', 'O item do Banner foi actualizado com sucesso.');
            }catch(Exception $error){
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao registrar o item do banner!');
            }
        }else{
            return redirect()->route('admin');
        }
    
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //      
        if (Gate::allows('isAdmin')) {
            try {
                DB::beginTransaction();
                
                $ID = decrypt($id);
                $bunner = Bunner::findOrFail($ID);

                if ($bunner->imagem && file_exists(public_path("admin/endidadesIMG/bunnerSlide/{$bunner->imagem}"))) {
                    unlink(public_path("admin/endidadesIMG/bunnerSlide/{$bunner->imagem}"));
                }

                $bunner->delete();
                DB::commit();

                 return redirect()->route('banners.index')->with('success', 'Item do bunner excluído com sucesso.');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao excluír otem do bunner!');
            }
        } else {
            return redirect()->route('admin');
        }
    }
}
