<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreCategoriaBeneficiosRequest;
use App\Http\Requests\UpdateCategoriaBeneficiosRequest;
use App\Models\AppConfig;
use App\Models\CategoriaBeneficio;
use App\Models\EntidadeSys;
use Exception;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\DB;
class CategoriaBeneficioController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $categorias = CategoriaBeneficio::all();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.configuracoes.categoriaBeneficios.index', compact('categorias', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.configuracoes.categoriaBeneficios.create', compact('entidadeVisual', 'config'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreCategoriaBeneficiosRequest $request)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try{
                DB::beginTransaction();

                $categoria = new CategoriaBeneficio();
                $categoria->nome = filter_var($request->nome, FILTER_SANITIZE_STRING);
                $categoria->estado = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $categoria->save();

                DB::commit();

                return redirect()->route('categoria-de-beneficio.index')->with('success', 'Categoria de Parceiro registrada com sucesso!');

            }catch(Exception $error){
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao registrar a Categoria de Parceiro!');
            }
        }else{
            return redirect()->route('admin');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $ID = decrypt($id);
        $categoria = CategoriaBeneficio::findOrFail($ID);
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.configuracoes.categoriaBeneficios.show', compact('categoria', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        //
        $ID = decrypt($id);
        $categoria = CategoriaBeneficio::findOrFail($ID);
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.configuracoes.categoriaBeneficios.edit', compact('categoria', 'entidadeVisual', 'config'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateCategoriaBeneficiosRequest $request, $id)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try {
                DB::beginTransaction();
                $ID = decrypt($id);
                $categoria = CategoriaBeneficio::findOrFail($ID); 

                $categoria->nome = filter_var($request->nome, FILTER_SANITIZE_STRING);
                $categoria->estado = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $categoria->save();

                DB::commit();

                return redirect()->route('categoria-de-beneficio.index')->with('success', 'Categoria de Benefício atualizada com sucesso!');
            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao atualizar a Categoria de Benefício!');
            }
        } else {
            return redirect()->route('admin');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor')) {
            try {
                DB::beginTransaction();
                
                $ID = decrypt($id);
                $categoria = CategoriaBeneficio::findOrFail($ID);

                $categoria->delete();
                DB::commit();

                return redirect()->route('categoria-de-beneficio.index')->with('success', 'Categoria de Benefício excluída com sucesso.');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao excluír a Categoria de Benefício!');
            }
        } else {
            return redirect()->route('admin');
        }
    }
}
