<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreCategoriaParceirosRequest;
use App\Http\Requests\UpdateCategoriaParceirosRequest;
use App\Models\AppConfig;
use App\Models\CategoriaParceiro;
use App\Models\EntidadeSys;
use Exception;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\DB;

class CategoriaParceiroController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $categorias = CategoriaParceiro::orderBy('created_at', 'desc')->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.configuracoes.categoriaParceiros.index', compact('categorias', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.configuracoes.categoriaParceiros.create', compact('entidadeVisual', 'config'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreCategoriaParceirosRequest $request)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try{
                DB::beginTransaction();

                $categoria = new CategoriaParceiro();
                $categoria->nome = filter_var($request->nome, FILTER_SANITIZE_STRING);
                $categoria->estado = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $categoria->save();

                DB::commit();

                return redirect()->route('categoria-de-parceiro.index')->with('success', 'Categoria de Parceiro registrada com sucesso!');

            }catch(Exception $error){
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao registrar a Categoria de Parceiro!');
            }
        }else{
            return redirect()->route('admin');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $ID = decrypt($id);
        $categoria = CategoriaParceiro::findOrFail($ID);
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.configuracoes.categoriaParceiros.show', compact('categoria', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        //
        $ID = decrypt($id);
        $categoria = CategoriaParceiro::findOrFail($ID);
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.configuracoes.categoriaParceiros.edit', compact('categoria', 'entidadeVisual', 'config'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateCategoriaParceirosRequest $request, $id)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try {
                DB::beginTransaction();
                $ID = decrypt($id);
                $categoria = CategoriaParceiro::findOrFail($ID); 

                $categoria->nome = filter_var($request->nome, FILTER_SANITIZE_STRING);
                $categoria->estado = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $categoria->save();

                DB::commit();

                return redirect()->route('categoria-de-parceiro.index')->with('success', 'Categoria de Parceiro atualizada com sucesso!');
            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao atualizar a Categoria de Parceiro!');
            }
        } else {
            return redirect()->route('admin');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor')) {
            try {
                DB::beginTransaction();
                
                $ID = decrypt($id);
                $categoria = CategoriaParceiro::findOrFail($ID);

                $categoria->delete();
                DB::commit();

                return redirect()->route('categoria-de-parceiro.index')->with('success', 'Categoria de Parceiro excluída com sucesso.');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao excluír a Categoria de Parceiro!');
            }
        } else {
            return redirect()->route('admin');
        }
    }
}
