<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\EmailLog;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Mail;
use App\General\DataGeneral;
use App\Models\AppConfig;
use App\Models\EntidadeSys;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class EmailLogController extends Controller
{
    //
    public function index()
    {
        //Listagem
        $logs = EmailLog::orderBy('created_at', 'desc')->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.auditoria.logsEmails.index',compact('logs', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //criação
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        
    }
    /**
     * Display the specified resource.
     */
    public function show(Request  $request,$id)
    {
        $id = decrypt($id);
        $log = EmailLog::findOrFail($id); // Busca o e-mail pelo ID
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.auditoria.logsEmails.show', compact('log', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Request  $request,$id)
    {
        //
    
    }


    public function update(Request $request, $id)
    {

        
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request  $request,$id)
    {

        
    }

 
    // Método para reenviar o e-mail
    public function reenviar(Request $request, $id)
    {
        //dd($id);
        // Valida permissões
        if (Gate::allows('isAdmin')) {
        
            DB::beginTransaction();
            $id = decrypt($id);
            $emailLog = EmailLog::findOrFail($id);

            // Aumenta o número de tentativas
            $emailLog->tentativas += 1;
            $emailLog->data_tentativa = DataGeneral::dataHoraActual(); 
            $emailLog->estado = 0;
            $emailLog->save();

            try {
                
                if (class_exists($emailLog->mail_class)) {
                    $dados = json_decode($emailLog->body, true);

                    Mail::to($emailLog->email_receptor)->send(new $emailLog->mail_class($dados));

                    $emailLog->estado = 1; 
                    $emailLog->user_id  = Auth::user()->id;
                    $emailLog->mensagem_erro = null;

                    $emailLog->save();
                    DB::commit();

                    return redirect()->route('logs-email.index')->with('success', 'E-mail reenviado com sucesso!');
                } else {
                    DB::rollBack();
                    return redirect()->route('logs-email.index')->with('error', 'Classe de e-mail '.$emailLog->mail_class.' não encontrada.');
                }
            } catch (\Exception $e) {
                // Em caso de erro, armazena a mensagem de erro
                $emailLog->mensagem_erro = $e->getMessage();
                $emailLog->save();
                DB::commit();

                return redirect()->route('logs-email.index')->with('error', 'Falha ao reenviar o e-mail, Email não reenviado ');
            }
        } else {
            return redirect()->route('logs-email.index')->with('error', 'Não tem autorização para executar esta ação');
        }
    }

    public function reenviarTodos(Request $request){
        $confirm = false;
        // Verifica permissões
        if (Gate::allows('isAdmin')) {
            DB::beginTransaction();

            try {
                // Obtém todos os registros de logs com estado 1
                $emailLogs = EmailLog::where('estado', 0)->get();

                if ($emailLogs->isEmpty()) {
                    return redirect()->route('logs-email.index')->with('success', 'Não foi encontrado nenhum Email por enviar.');
                }

                foreach ($emailLogs as $emailLog) {
                    // Incrementa tentativas
                    $emailLog->tentativas += 1;
                    $emailLog->data_tentativa = DataGeneral::dataHoraActual();

                    try {
                        if (class_exists($emailLog->mail_class)) {
                            $dados = json_decode($emailLog->body, true);

                            Mail::to($emailLog->email_receptor)->send(new $emailLog->mail_class($dados));

                            $emailLog->estado = 1;
                            $emailLog->user_id = Auth::user()->id;
                            $emailLog->mensagem_erro = null;
                        } else {
                            DB::rollBack();
                            return redirect()->route('logs-email.index')->with('error', 'Classe de e-mail '.$emailLog->mail_class.' não encontrada.');

                        }
                    } catch (\Exception $e) {
                        $emailLog->mensagem_erro = $e->getMessage();
                        $emailLog->save();
                        DB::commit();
                        $confirm = true;
                    }

                    $emailLog->save();
                    DB::commit();
                }

                if($confirm){
                    return redirect()->route('logs-email.index')->with('warning', 'Alguns e-mails foram enviados com sucesso, mas outros não!');
                }

                return redirect()->route('logs-email.index')->with('success', 'E-mails reenviados com sucesso!');
            } catch (\Exception $e) {
                DB::rollBack();
                return redirect()->route('logs-email.index')->with('error', 'Erro ao processar o reenvio ');
            }
        } else {
            return redirect()->route('logs-email.index')->with('error', 'Não tem autorização para executar esta ação.');
        }
    }

}
