<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreMidiaEventosRequest;
use App\Http\Requests\UpdateMidiaEventosRequest;
use App\Models\AppConfig;
use App\Models\EntidadeSys;
use App\Models\Evento;
use App\Models\MidiaEvento;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;

class MidiaEventoController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $midias = MidiaEvento::latest()->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.midiaEvento.index', compact('midias', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        $eventos = Evento::where('estado', 1)->get();
        return view('admin.midiaEvento.create', compact('eventos', 'entidadeVisual', 'config'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreMidiaEventosRequest $request)
    {
        //
        $tipo = null;
        $pathFoto = null;
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try{
                DB::beginTransaction();

                if ($request->file('imagem') != null) {
                    $foto = $request->file('imagem');
                    $pathFoto = $foto->getClientOriginalName();

                    $ext = $foto->getClientOriginalExtension();
                    $tipo = in_array($ext, ['mp4', 'webm']) ? 'Video' : 'Imagem';

                    $foto->move(public_path("admin/eventos/midia"), $pathFoto);
                }

                $midia = new MidiaEvento();
                $midia->evento_id = filter_var($request->evento_id, FILTER_SANITIZE_STRING);
                $midia->tipo = $tipo;
                $midia->link_video         = filter_var($request->link, FILTER_SANITIZE_STRING);
                $midia->ficheiro         = $pathFoto;
                $midia->estado           = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $midia->save();

                

                DB::commit();

                return redirect()->route('midias-eventos.index')->with('success', 'Midia adicionada com sucesso!');

            }catch(Exception $error){
                DB::rollBack();
                dd($error);
                return redirect()->back()->withErrors('Falha ao registrar o Midia!');
            }
        }else{
            return redirect()->route('admin');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $ID = decrypt($id);
        $midia = MidiaEvento::findOrFail($ID);
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        $eventos = Evento::where('estado', 1)->get();

        return view('admin.midiaEvento.show', compact('eventos', 'midia', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        //
        $ID = decrypt($id);
        $midia = MidiaEvento::findOrFail($ID);
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        $eventos = Evento::where('estado', 1)->get();
        return view('admin.midiaEvento.edit', compact('midia','eventos', 'entidadeVisual', 'config'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateMidiaEventosRequest $request, $id)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try {
                DB::beginTransaction();

                $ID = decrypt($id);
                $midia = MidiaEvento::findOrFail($ID);
                $pathFoto = $midia->ficheiro;
                $tipo = $midia->tipo;

                if ($request->file('imagem') != null) {
                    if ($pathFoto && file_exists(public_path("admin/eventos/midia/{$pathFoto}"))) {
                        unlink(public_path("admin/eventos/midia/{$pathFoto}"));
                    }

                    $foto = $request->file('imagem');
                    $pathFoto = $foto->getClientOriginalName();

                    $ext = $foto->getClientOriginalExtension();
                    $tipo = in_array($ext, ['mp4', 'webm']) ? 'Video' : 'Imagem';

                    $foto->move(public_path("admin/eventos/midia"), $pathFoto);
                }

                $midia->evento_id = filter_var($request->evento_id, FILTER_SANITIZE_STRING);
                $midia->tipo = $tipo;
                $midia->link_video         = filter_var($request->link, FILTER_SANITIZE_STRING);
                $midia->ficheiro         = $pathFoto;
                $midia->estado           = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $midia->save();

                DB::commit();

                return redirect()->route('midias-eventos.index')->with('success', 'Midia atualizada com sucesso!');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao atualizar a Midia!');
            }
        } else {
            return redirect()->route('admin');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        if (Gate::allows('isAdmin')) {
            try {
                DB::beginTransaction();
                
                $ID = decrypt($id);
                $midia = MidiaEvento::findOrFail($ID);

                if ($midia->ficheiro && file_exists(public_path("admin/eventos/midia/{$midia->ficheiro}"))) {
                    unlink(public_path("admin/eventos/midia/{$midia->ficheiro}"));
                }

                $midia->delete();
                DB::commit();

                return redirect()->route('midias-eventos.index')->with('success', 'Midia Eliminada com sucesso.');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao excluír a Midia!');
            }
        } else {
            return redirect()->route('admin');
        }
    }
}
