<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreMidiaNoticiaRequest;
use App\Http\Requests\UpdateMidiaNoticiaRequest;
use App\Models\AppConfig;
use App\Models\EntidadeSys;
use App\Models\MidiaNoticia;
use App\Models\Noticia;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;

class MidiaNoticiaController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $midias = MidiaNoticia::latest()->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        return view('admin.midiaNoticia.index', compact('midias', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        $noticias = Noticia::where('estado', 1)->get();
        return view('admin.midiaNoticia.create', compact('noticias', 'entidadeVisual', 'config'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreMidiaNoticiaRequest $request)
    {
        //
        $tipo = null;
        $pathFoto = null;
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try{
                DB::beginTransaction();

                if ($request->file('imagem') != null) {
                    $foto = $request->file('imagem');
                    $pathFoto = $foto->getClientOriginalName();

                    $ext = $foto->getClientOriginalExtension();
                    $tipo = in_array($ext, ['mp4', 'webm']) ? 'Video' : 'Imagem';

                    $foto->move(public_path("admin/imagens/noticias/midia"), $pathFoto);
                }

                $midia = new MidiaNoticia();
                $midia->noticia_id = filter_var($request->noticia_id, FILTER_SANITIZE_STRING);
                $midia->tipo = $tipo;
                $midia->link_video         = filter_var($request->link, FILTER_SANITIZE_STRING);
                $midia->ficheiro         = $pathFoto;
                $midia->estado           = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $midia->save();

                

                DB::commit();

                return redirect()->route('midias-noticias.index')->with('success', 'Midia adicionada com sucesso!');

            }catch(Exception $error){
                DB::rollBack();
                dd($error);
                return redirect()->back()->withErrors('Falha ao registrar o Midia!');
            }
        }else{
            return redirect()->route('admin');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $ID = decrypt($id);
        $midia = MidiaNoticia::findOrFail($ID);
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        $noticias = Noticia::where('estado', 1)->get();

        return view('admin.midiaNoticia.show', compact('noticias', 'midia', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        //
        $ID = decrypt($id);
        $midia = MidiaNoticia::findOrFail($ID);
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();
        $noticias = Noticia::where('estado', 1)->get();
        return view('admin.midiaNoticia.edit', compact('midia','noticias', 'entidadeVisual', 'config'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateMidiaNoticiaRequest $request, $id)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try {
                DB::beginTransaction();

                $ID = decrypt($id);
                $midia = MidiaNoticia::findOrFail($ID);
                $pathFoto = $midia->ficheiro;
                $tipo = $midia->tipo;

                if ($request->file('imagem') != null) {
                    if ($pathFoto && file_exists(public_path("admin/imagens/noticias/midia/{$pathFoto}"))) {
                        unlink(public_path("admin/imagens/noticias/midia/{$pathFoto}"));
                    }

                    $foto = $request->file('imagem');
                    $pathFoto = $foto->getClientOriginalName();

                    $ext = $foto->getClientOriginalExtension();
                    $tipo = in_array($ext, ['mp4', 'webm']) ? 'Video' : 'Imagem';

                    $foto->move(public_path("admin/imagens/noticias/midia"), $pathFoto);
                }

                $midia->noticia_id = filter_var($request->noticia_id, FILTER_SANITIZE_STRING);
                $midia->tipo = $tipo;
                $midia->link_video         = filter_var($request->link, FILTER_SANITIZE_STRING);
                $midia->ficheiro         = $pathFoto;
                $midia->estado           = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $midia->save();

                DB::commit();

                return redirect()->route('midias-noticias.index')->with('success', 'Midia atualizada com sucesso!');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao atualizar a Midia!');
            }
        } else {
            return redirect()->route('admin');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        if (Gate::allows('isAdmin')) {
            try {
                DB::beginTransaction();
                
                $ID = decrypt($id);
                $midia = MidiaNoticia::findOrFail($ID);

                if ($midia->ficheiro && file_exists(public_path("admin/imagens/noticias/midia/{$midia->ficheiro}"))) {
                    unlink(public_path("admin/imagens/noticias/midia/{$midia->ficheiro}"));
                }

                $midia->delete();
                DB::commit();

                return redirect()->route('midias-noticias.index')->with('success', 'Midia Eliminada com sucesso.');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao excluír a Midia!');
            }
        } else {
            return redirect()->route('admin');
        }
    }
}
