<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreMensagemPresidenteRequest;
use App\Http\Requests\UpdateMensagemPresidenteRequest;
use App\Models\AppConfig;
use App\Models\EntidadeSys;
use App\Models\MembroComissao;
use App\Models\PR_Mensagem;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;

class PRMensagemController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $mensagens = PR_Mensagem::orderBy('created_at', 'desc')->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.mensagemPR.index', compact('mensagens', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $prs = MembroComissao::where('estado', 1)
                            ->whereHas('cargos', function ($query) {
                                $query->where('principal', 1);
                            })
                            ->get();

        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.mensagemPR.create', compact('prs', 'entidadeVisual', 'config'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreMensagemPresidenteRequest $request)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try{
                DB::beginTransaction();

                $mensagens = PR_Mensagem::all();
                foreach ($mensagens as $mensagen) {
                    if($mensagen->estado == 1 && $request->estado == 1){
                        return redirect()->back()->withErrors('Já existe um Mensagem do Presidente Activa!');
                    }
                }

                $mensagem = new PR_Mensagem();
                $mensagem->mensagem = $request->input('mensagem');
                $mensagem->lema = filter_var($request->lema, FILTER_SANITIZE_STRING);
                $mensagem->membro_id = filter_var($request->membro, FILTER_SANITIZE_STRING);
                $mensagem->estado = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $mensagem->save();

                DB::commit();

                return redirect()->route('mensagem-presidente.index')->with('success', 'Mensagem do Presidente registrada com sucesso!');

            }catch(Exception $error){
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao registrar Mensagem do Presidente!');
            }
        }else{
            return redirect()->route('admin');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $ID = decrypt($id);
        $mensagem = PR_Mensagem::findOrFail($ID);
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.mensagemPR.show', compact('mensagem', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        //
        $ID = decrypt($id);
        $mensagem = PR_Mensagem::findOrFail($ID);
        $prs = MembroComissao::where('estado', 1)
                            ->whereHas('cargos', function ($query) {
                                $query->where('principal', 1);
                            })
                            ->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.mensagemPR.edit', compact('mensagem','prs', 'entidadeVisual', 'config'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateMensagemPresidenteRequest $request, $id)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try {
                DB::beginTransaction();

                $ID = decrypt($id);

                $mensagens = PR_Mensagem::all();
                foreach ($mensagens as $mensagen) {
                    if($mensagen->estado == 1 && $request->estado == 1){
                        if(!($mensagen->id == $ID)){
                            return redirect()->back()->withErrors('Já existe um Mensagem do Presidente Activa!');
                        }
                    }
                }
                
                $mensagem = PR_Mensagem::findOrFail($ID);

                $mensagem->mensagem = $request->input('mensagem');
                $mensagem->lema = filter_var($request->lema, FILTER_SANITIZE_STRING);
                $mensagem->membro_id = filter_var($request->membro, FILTER_SANITIZE_STRING);
                $mensagem->estado = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $mensagem->save();

                DB::commit();

                return redirect()->route('mensagem-presidente.index')->with('success', 'Mensagem do Presidente atualizada com sucesso!');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao atualizar a Mensagem do Presidente!');
            }
        } else {
            return redirect()->route('admin');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id){
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor')) {
            try {
                DB::beginTransaction();
                
                $ID = decrypt($id);
                $mensagem = PR_Mensagem::findOrFail($ID);

                $mensagem->delete();
                DB::commit();

                return redirect()->route('mensagem-presidente.index')->with('success', 'Mensagem do Presidente excluída com sucesso.');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao excluír a Mensagem do Presidente!');
            }
        } else {
            return redirect()->route('admin');
        }
    }
}
