<?php

namespace App\Http\Controllers;

use App\Http\Requests\StorePerguntasFrequentesRequest;
use App\Http\Requests\UpdatePerguntasFrequentesRequest;
use App\Models\AppConfig;
use App\Models\EntidadeSys;
use App\Models\PerguntaFrequente;
use Exception;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\DB;

class PerguntaFrequenteController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $perguntas = PerguntaFrequente::orderBy('created_at', 'desc')->get();
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.perguntasFrequentes.index', compact('perguntas', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.perguntasFrequentes.create', compact('entidadeVisual', 'config'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StorePerguntasFrequentesRequest $request)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try{
                DB::beginTransaction();
                $faq = new PerguntaFrequente();
                $faq->pergunta = filter_var($request->pergunta, FILTER_SANITIZE_STRING);
                $faq->resposta = filter_var($request->resposta, FILTER_SANITIZE_STRING);
                $faq->estado = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $faq->save();

                DB::commit();

                return redirect()->route('perguntas-frequentes.index')->with('success', 'Pergunta Frequênte registrada com sucesso!');

            }catch(Exception $error){
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao registrar Pergunta Frequênte!');
            }
        }else{
            return redirect()->route('admin');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        //
        $ID = decrypt($id);
        $faq = PerguntaFrequente::findOrFail($ID);
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.perguntasFrequentes.show', compact('faq', 'entidadeVisual', 'config'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        //
        $ID = decrypt($id);
        $faq = PerguntaFrequente::findOrFail($ID);
        $entidadeVisual = EntidadeSys::getLogoByLocal(11);
        $config = AppConfig::current();

        return view('admin.perguntasFrequentes.edit', compact('faq', 'entidadeVisual', 'config'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdatePerguntasFrequentesRequest $request, $id)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            try {
                DB::beginTransaction();

                $ID = decrypt($id);
                $faq = PerguntaFrequente::findOrFail($ID);
                $faq->pergunta = filter_var($request->pergunta, FILTER_SANITIZE_STRING);
                $faq->resposta = filter_var($request->resposta, FILTER_SANITIZE_STRING);
                $faq->estado = filter_var($request->estado, FILTER_SANITIZE_STRING);
                $faq->save();

                DB::commit();

                return redirect()->route('perguntas-frequentes.index')->with('success', 'Pergunta Frequênte atualizada com sucesso!');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao atualizar a Pergunta Frequênte!');
            }
        } else {
            return redirect()->route('admin');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        if (Gate::allows('isAdmin') || Gate::allows('isGestor')) {
            try {
                DB::beginTransaction();

                $ID = decrypt($id);
                $faq = PerguntaFrequente::findOrFail($ID);

                $faq->delete();
                DB::commit();

                return redirect()->route('perguntas-frequentes.index')->with('success', 'Pergunta Frequênte excluída com sucesso.');

            } catch (Exception $error) {
                DB::rollBack();
                return redirect()->back()->withErrors('Falha ao excluír a Pergunta Frequênte!');
            }
        } else {
            return redirect()->route('admin');
        }
    }
}
