<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use  Illuminate\Support\Facades\Session;

class CandidaturaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {


        return [
            'nome' => 'required|string|max:100',
            'n_identificacao' => 'required|string|unique:candidatos|max:60',
            'tipo_documento' => 'required|string|max:11',
            'email' => 'required|email|unique:candidatos|max:100|',
            'telefone' => 'required|string|max:60',
            'n_mecanografico' => 'required|string|unique:candidatos|max:15',
            'orgao_id' => 'required|integer|exists:orgao,id',
            'profissao_id' => 'required|integer|exists:profissao,id',
            'salario' => 'required',

            'foto_frente' => 'image|mimes:jpeg,png,jpg|max:10240',
            'foto_verso'  => 'image|mimes:jpeg,png,jpg|max:10240',
            'foto_Dec_Servico'  => 'image|mimes:jpeg,png,jpg|max:10240',

            'arquivo_identificacao' => 'file|mimes:pdf|max:2048',
            'arquivo_declaracao' => 'file|mimes:pdf|max:2048',

            //re-capctha
             //'g-recaptcha-response' => 'required|recaptcha',
             'g-recaptcha-response' => function ($attribute, $value, $fail){
                $secretkey = config('services.recaptcha.secret');
                $response = $value;
                $userIP = $_SERVER['REMOTE_ADDR'];
                $url = "https://www.google.com/recaptcha/api/siteverify?secret=$secretkey&response=$response&remoteip=$userIP";
                $response = \file_get_contents($url);
                $response = json_decode($response);
                if(!$response->success){
                   Session::flash('g-recaptcha-response','porfavor valida o reCaptcha');
                    Session::flash('alert-class','alert-danger');
                   $fail($attribute.' Falhou, queira validar se não é robô.');

               }

            }
        ];
    }

        /**
     * Get the error messages for the defined validation rules.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'nome.required' => 'O campo Nome Completo é de preenchimento obrigatório.',
            'salario.required' => 'O campo Salário é de preenchimento obrigatório.',
            'n_identificacao.required' => 'O campo Número de Identificação é de preenchimento obrigatório.',
            'tipo_documento.required' => 'O campo Tipo de Documento é de preenchimento obrigatório.',
            'email.required' => 'O campo E-mail é de preenchimento obrigatório.',
            'telefone.required' => 'O campo Número de Telefone é de preenchimento obrigatório.',
            'n_mecanografico.required' => 'O campo Número Mecanográfico é de preenchimento obrigatório.',
            'orgao_id.required' => 'O campo Órgão é de preenchimento obrigatório.',
            'profissao_id.required' => 'O campo Profissão é de preenchimento obrigatório.',
            // 'arquivo_identificacao.required' => 'O campo Arquivo de Identificação é de preenchimento obrigatório.',
            // 'arquivo_declaracao.required' => 'O campo Arquivo de Declaração é de preenchimento obrigatório.',
            'email.unique' => 'Este E-mail já está a ser usado.',
            'n_mecanografico.unique' => 'Este Número Mecanográfico já está a ser usado.',
            
            'n_identificacao.unique' => 'Este Número do Documento de Identificação já está a ser usado.',
            
            'arquivo_identificacao.file' => 'O arquivo de identificação deve ser um ficheiro válido.',
            'arquivo_identificacao.mimes' => 'O arquivo de identificação deve estar no formato PDF.',
            'arquivo_identificacao.max' => 'O arquivo de identificação não pode ter mais de 2MB.',

            'arquivo_declaracao.file' => 'O arquivo de declaração deve ser um ficheiro válido.',
            'arquivo_declaracao.mimes' => 'O arquivo de declaração deve estar no formato PDF.',
            'arquivo_declaracao.max' => 'O arquivo de declaração não pode ter mais de 2MB.',

            // 'foto_frente.required' => 'A foto da frente do documento é obrigatória.',
            'foto_frente.image'    => 'A frente do documento deve ser uma imagem válida.',
            'foto_frente.mimes'    => 'A foto da frente deve estar nos formatos: JPEG, PNG ou JPG.',
            'foto_frente.max'      => 'A foto da frente não pode ultrapassar 10MB.',

            // 'foto_verso.required' => 'A foto do verso do documento é obrigatória.',
            'foto_verso.image'    => 'O verso do documento deve ser uma imagem válida.',
            'foto_verso.mimes'    => 'A foto do verso deve estar nos formatos: JPEG, PNG ou JPG.',
            'foto_verso.max'      => 'A foto do verso não pode ultrapassar 10MB.',

            // 'foto_Dec_Servico.required' => 'A foto do verso do documento é obrigatória.',
            'foto_Dec_Servico.image'    => 'A foto da Declaração deve ser uma imagem válida.',
            'foto_Dec_Servico.mimes'    => 'A foto da Declaração deve estar nos formatos: JPEG, PNG ou JPG.',
            'foto_Dec_Servico.max'      => 'A foto da Declaração não pode ultrapassar 10MB.',

        ];
    }
}
