<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class StoreBeneficioRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'beneficio' => 'required|string|max:250',
            'descricao' => 'nullable|string|max:250',
            'categoria' => 'required',
            'estado' => 'required',
        ];
    }

     /**
     * Mensagens de erro personalizadas.
     */
    public function messages(): array
    {
        return [
            'beneficio.required' => 'O campo "Benefício" é obrigatório.',
            'beneficio.string' => 'O campo "Benefício" deve ser um texto válido.',
            'beneficio.max' => 'O campo "Benefício" não pode ter mais de 250 caracteres.',

            'descricao.string' => 'O campo "Descrição" deve ser um texto válido.',
            'descricao.max' => 'O campo "Descrição" não pode ter mais de 250 caracteres.',
            
            'categoria.required' => 'O estado do Benefício é obrigatório.',
            
            'estado.required' => 'O estado do Benefício é obrigatório.',
            
        ];
    }
}
