<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class StoreCategoriaParceirosRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'nome' => 'required|string|max:200',
            'estado' => 'required',
        ];
    }

    
     /**
     * Mensagens de erro personalizadas.
     */
    public function messages(): array
    {
        return [
            'nome.required' => 'O campo "Nome da Categoria" é obrigatório.',
            'nome.string' => 'O campo "Nome da Categoria" deve ser um texto válido.',
            'nome.max' => 'O campo "Nome da Categoria" não pode ter mais de 200 caracteres.',

            'estado.required' => 'O estado da Categoria é obrigatório.',
        ];
    }
}
