<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class StoreMensagemPresidenteRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'membro' => 'required',
            'lema' => 'required|string|max:200',
            'mensagem' => 'required|string',
            // 'mensagem' => 'required|string|max:1500',
            'estado' => 'required',
        ];
    }

     /**
     * Mensagens de erro personalizadas.
     */
    public function messages(): array
    {
        return [
            'membro.required' => 'O campo "Presidente" é obrigatório.',

            'lema.required' => 'O campo "Lema" é obrigatório.',
            'lema.string' => 'O campo "Lema" deve ser um texto válido.',
            'lema.max' => 'O campo "Lema" não pode ter mais de 200 caracteres.',

            'mensagem.required' => 'O campo "Mensagem" é obrigatório.',
            'mensagem.string' => 'O campo "Mensagem" deve ser um texto válido.',
            // 'mensagem.max' => 'O campo "Mensagem" não pode ter mais de 1500 caracteres.',

            'estado.required' => 'O estado é obrigatório.',
        ];
    }
}
