<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class StoreMidiaNoticiaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'noticia_id' => 'required',
            'imagem' => 'mimes:mp4,webm,jpeg,jpg,png|max:8192',
            'estado' => 'required',
        ];
    }

     /**
     * Mensagens de erro personalizadas.
     */
    public function messages(): array
    {
        return [
            'noticia_id.required' => 'O campo Noticia é obrigatório.',
    
            'imagem.mimes' => 'O arquivo deve ser uma imagem (jpeg, jpg, png) ou um vídeo (mp4, webm).',
            'imagem.max' => 'O arquivo não pode ter mais que 8 MB. Caso seja um video, submeta o link.',

            'estado.required' => 'O campo estado é obrigatório.',
        ];
    }
}
