<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class UpdateBunnerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (Gate::allows('isAdmin')) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            //
            'titulo' => 'required|string|max:200',
            'imagem' => 'image|mimes:jpeg,png,jpg',
            'cor_titulo' => 'nullable|string|max:7',
            'fixo' => 'required|boolean',
            'estado' => 'required|boolean',
        ];
    }

    public function messages()
    {
        return [
            'titulo.required' => 'O título é obrigatório.',
            'titulo.string' => 'O título deve ser um texto.',
            'titulo.max' => 'O título não pode ter mais de 200 caracteres.',

            'imagem.image' => 'O arquivo enviado deve ser uma imagem.',
            'imagem.mimes' => 'A imagem deve ser do tipo: jpeg, png ou jpg.',

            'cor_titulo.string' => 'A cor do título deve ser um texto.',
            'cor_titulo.max' => 'A cor do título não pode ter mais de 7 caracteres.',

            'fixo.required' => 'O estado é obrigatório.',
            'fixo.boolean' => 'O campo "Imagem Fixa" deve ser Sim ou Não (1 ou 0).',

            'estado.required' => 'O estado é obrigatório.',
            'estado.boolean' => 'O estado deve ser verdadeiro ou falso (1 ou 0).',
        ];
    }
}
