<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class UpdateLegislacaoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'titulo' => 'required|string|max:100',
            'subtitulo' => 'required|string|max:100',
            'estado' => 'required|string|in:0,1',
            'documento' => 'file|mimes:pdf|max:10240',
        ];
    }


    public function messages(): array
    {
        return [
            'titulo.required' => 'O campo "Título" é obrigatório.',
            'titulo.string' => 'O campo "Título" deve ser uma string.',
            'titulo.max' => 'O campo "Título" não pode exceder 50 caracteres.',
            
            'subtitulo.required' => 'O campo "Sub-Título" é obrigatório.',
            'subtitulo.string' => 'O campo "Sub-Título" deve ser uma string.',
            'subtitulo.max' => 'O campo "Sub-Título" não pode exceder 50 caracteres.',
            
            'estado.required' => 'O campo "Estado" é obrigatório.',
            'estado.string' => 'O campo "Estado" deve ser uma string.',
            'estado.in' => 'O campo Estado deve ser "0" (Inativo) ou "1" (Ativo).',
            
            'documento.file' => 'O campo "Documento" deve ser um arquivo válido (PDF).',
            'documento.mimes' => 'O campo "Documento" deve ser um arquivo do tipo PDF.',
            'documento.max' => 'O Documento não pode ser maior que 10 MB.',
        ];
    }
}
