<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class UpdateNoticiaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'titulo' => 'required|string|max:200',
            'data_publicacao' => 'required|date',
            'resumo' => 'required|string|max:500',
            'foto' => 'image|mimes:jpeg,png,jpg,gif|max:2048',
            'corpo_noticia' => 'required|string',
            'destaque' => 'required',
            'estado' => 'required',
        ];
    }

    public function messages(): array
    {
        return [
            'titulo.required' => 'O campo "Título" é obrigatório.',
            'titulo.string' => 'O campo "Título" deve ser um texto válido.',
            'titulo.max' => 'O campo "Título" não pode ter mais de 200 caracteres.',


            'data_publicacao.required' => 'A data de publicação é obrigatória.',
            'data_publicacao.date' => 'A data de publicação deve ser uma data válida.',
            'data_publicacao.before' => 'A data de publicação não pode ser posterior à data de hoje.',

            'resumo.required' => 'O campo "Resumo" é obrigatório.',
            'resumo.string' => 'O campo "Resumo" deve ser um texto válido.',
            'resumo.max' => 'O campo "Resumo" não pode ter mais de 500 caracteres.',

            'foto.image' => 'O arquivo enviado deve ser uma imagem.',
            'foto.required' => 'A imagem é obrigatória.',
            'foto.mimes' => 'A imagem deve estar nos formatos: jpeg, png ou jpg',
            'foto.max' => 'A imagem não pode ter mais de 2MB.',

            'corpo_noticia.required' => 'O corpo da notícia é obrigatório.',
            'corpo_noticia.string' => 'O corpo da notícia deve ser um texto válido.',

            'destaque.required' => 'Informe se a notícia será destaque.',
            'estado.required' => 'O estado da notícia é obrigatório.',
        ];
    }
}
