<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class UpdateParceirosRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $userId = decrypt($this->id);

        return [
            'nome' => 'required|string|max:100',
            'endereco' => 'required',
            'telefone' => 'required|string|max:15|unique:parceiros,telefone,' . $userId,
            'site' => 'max:150',
            'estado' => 'required',
            'categoria' => 'required|exists:categoria_parceiros,id',
            'foto' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
        ];
    }

    /**
     * Mensagens de erro personalizadas.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'nome.required' => 'O campo "Nome do Parceiro" é obrigatório.',
            'nome.string' => 'O campo "Nome do Parceiro" deve ser um texto válido.',
            'nome.max' => 'O campo "Nome do Parceiro" não pode ter mais de 100 caracteres.',

            'endereco.required' => 'O campo "Endereço" é obrigatório.',

            'telefone.required' => 'O campo "Telefone" é obrigatório.',
            'telefone.string' => 'O campo "Telefone" deve ser um texto válido.',
            'telefone.max' => 'O campo "Telefone" não pode ter mais de 15 caracteres.',
            'telefone.unique' => 'Este Número de telefone já está a ser utilizado por outro Parceiro.',

            'site.max' => 'O campo "Site" não pode ter mais de 150 caracteres.',

            'estado.required' => 'O campo "Estado" é obrigatório.',

            'categoria.required' => 'O campo "Categoria do Parceiro" é obrigatório.',
            'categoria.exists' => 'A Categoria do Parceiro selecionado não é válida.',

            'foto.image' => 'O arquivo deve ser uma imagem.',
            'foto.mimes' => 'A imagem deve estar nos formatos: jpeg, png ou jpg',
            'foto.max' => 'A imagem não pode ter mais de 2MB.',
        ];
    }
}
