<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class UpdateValoresRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if (Gate::allows('isAdmin') || Gate::allows('isGestor') || Gate::allows('isEditor')) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'nome' => 'required|string|max:200',
            'descricao' => 'required|string|max:2000',
            // 'foto' => 'image|mimes:jpeg,png,jpg,gif|max:2048',
            'estado' => 'required',
        ];
    }

     /**
     * Mensagens de erro personalizadas.
     */
    public function messages(): array
    {
        return [
            'nome.required' => 'O campo "Nome" é obrigatório.',
            'nome.string' => 'O campo "Nome" deve ser um texto válido.',
            'nome.max' => 'O campo "Nome" não pode ter mais de 300 caracteres.',

            'descricao.required' => 'O campo "Descrição" é obrigatório.',
            'descricao.string' => 'O campo "Descrição" deve ser um texto válido.',
            'descricao.max' => 'O campo "Descrição" não pode ter mais de 300 caracteres.',

            // 'foto.image' => 'O arquivo enviado deve ser uma imagem.',
            // 'foto.mimes' => 'A imagem deve estar nos formatos: jpeg, png ou jpg',
            // 'foto.max' => 'A imagem não pode ter mais de 2MB.',

            'estado.required' => 'O estado é obrigatório.',
        ];
    }
}
