<?php

namespace App\Mail;

use App\Models\EntidadeSys;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ResetCode extends Mailable
{
    use Queueable, SerializesModels;

    public $data;

    public function __construct($data)
    {
        //
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        //dd($this->data);
        $entidadeVisual_header = EntidadeSys::getLogoByLocal(1);
        $entidadeVisual_footer = EntidadeSys::getLogoByLocal(2);
        return $this
            ->from(config('mail.from.address'))
            ->subject($this->data['assunto'])
            ->view('emailResposta.contentResetCode', compact('entidadeVisual_header', 'entidadeVisual_footer'))
            ->with('data', $this->data);
    }
}
