<?php

namespace App\Mail;

use App\Models\EntidadeSys;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SendMail extends Mailable
{
    use Queueable, SerializesModels;

    public $data;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $entidadeVisual_header = EntidadeSys::getLogoByLocal(1);
        // $entidadeVisual_footer = EntidadeSys::getLogoByLocal(2);
        return $this
            ->from( config('mail.from.contact_address'))
            ->subject('Contacto do Portal')
            ->view('emailResposta.contacto', compact('entidadeVisual_header'))
            ->with('data', $this->data);
    }
}

// Mail::mailer('contact')->raw('Hello World!', function($msg) {$msg->to('longui@hotmail.com')->subject('Test Email'); });
