<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AuditoriaGeral extends Model
{
    use HasFactory;

    protected $table = 'auditoria_gerals';

    protected $fillable = [
        'user_id',
        'evento',
        'data_registo',
        'endereco_ip',
        'auditable_type',
        'auditable_id',
        'descricao',
        'old_data',
        'new_data',	
    ];

    public function auditable()
    {
        return $this->morphTo();
    }

    public function users()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }
}
