<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Candidato extends Model
{
    use HasFactory;
    protected $table = 'candidatos';

    protected $fillable = [
        'nome',
        'n_identificacao',
        'tipo_documento',
        'email',
        'telefone',
        'n_mecanografico',
        'orgao_id', 
        'arquivo_identificacao',
        'arquivo_declaracao',
        'arquivo_declaracao',
        'estado',
    ];

    public function orgao()
    {
        return $this->belongsTo(Orgao::class, 'orgao_id');
    }
}
