<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use App\General\AuditoriaGeneral;

class EmailLog extends Model
{
    use HasFactory;

    protected $table = 'email_logs';

    protected $fillable = [
        'email_receptor',
        'email_emissor',
        'assunto',
        'mail_class',
        'body',
        'estado',
        'user_id',
        'mensagem_erro',
        'data_tentativa',	
        'tentativas',
        'prioridade',
    ];

    public function users()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }

    protected static function booted(){
        static::updated(function ($model) {
            $userId = Auth::user() ? Auth::user()->id : null;
            AuditoriaGeneral::log($userId, 'updated', $model->id, $model, $model->getOriginal(), $model->getChanges(), 'Actualização dos dados do Log de Email');
        });

        static::created(function ($model) {
                $userId = Auth::user() ? Auth::user()->id : null;
          AuditoriaGeneral::log($userId, 'created', $model->id, $model, null, $model->toArray(), 'Registo de um novo Log de Email');
        });

		static::deleted(function ($model) {
            $userId = Auth::user() ? Auth::user()->id : null;
			AuditoriaGeneral::log($userId, 'deleted', $model->id, $model, $model->toArray(), null, 'Eliminação de um Log de Email');

		});
    }
}
