<?php

namespace App\Models;

use App\General\AuditoriaGeneral;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class EntidadeSys extends Model
{
    use HasFactory;

    protected $table = 'entidades_sys';
	
	protected $fillable = [
		'nome',
		'localizacao',
		'logo',
		'estado',
	];

	public static function getLogoByLocal($local)
	{
		return self::where('estado', 1)
			->where(function ($query) use ($local) {
				$query->where('localizacao', $local)
					->orWhere('localizacao', 13);
			})
			->first();
	}

    protected static function booted(){
        static::updated(function ($model) {
			AuditoriaGeneral::log(Auth::user()->id, 'updated', $model->id, $model, $model->getOriginal(), $model->getChanges(), 'Actualização dos dados da Entidade do Sistema');
        });

		static::created(function ($model) {
			AuditoriaGeneral::log(Auth::user()->id, 'created', $model->id, $model, null, $model->toArray(), 'Registo de uma nova Entidade do Sistema');
		});

		static::deleted(function ($model) {
			AuditoriaGeneral::log(Auth::user()->id, 'deleted', $model->id, $model, $model->toArray(), null, 'Eliminação de uma Entidade do Sistema');
		});
    }
}
