<?php

namespace App\Models;

use App\General\AuditoriaGeneral;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class Legislacao extends Model
{
    use HasFactory;

    protected static function booted(){
        
        static::updated(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'updated', $model->id, $model, $model->getOriginal(), $model->getChanges(), 'Actualização do registo de um Documento Legislativo');
        });

		static::created(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'created', $model->id, $model, null, $model->toArray(), 'Registo de um novo Documento Legislativo');
		});

		static::deleted(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'deleted', $model->id, $model, $model->toArray(), null, 'Delete de um Documento Legislativo');
		});
    }
}
