<?php

namespace App\Models;

use App\General\AuditoriaGeneral;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class Sobre extends Model
{
    use HasFactory;

    protected $table = 'sobre';

    protected $fillable = [
        'conteudo',
        'estado',
    ];

    protected $casts = [
        'estado' => 'boolean',
    ];

    public static function current(): self
    {
        return static::query()->first() ?? static::query()->create();
    }

    protected static function booted(){
        
        static::updated(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'updated', $model->id, $model, $model->getOriginal(), $model->getChanges(), 'Actualização do registo da Secção Sobre');
        });

		static::created(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'created', $model->id, $model, null, $model->toArray(), 'Registo da Secção Sobre');
		});

		static::deleted(function ($model) {
            $id_user = Auth::check() ? Auth::user()->id : null;
			AuditoriaGeneral::log($id_user, 'deleted', $model->id, $model, $model->toArray(), null, 'Delete da Secção Sobre');
		});
    }
}
