<?php

namespace App\Services;

use App\General\DataGeneral;
use App\Models\SmsLogs;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class TelcoSmsService
{
    protected string $apiKey;
    protected string $endpoint;

    public function __construct()
    {
        $this->apiKey = config('services.telcosms.api_key');
        $this->endpoint = 'https://telcosms.co.ao/send_message';
    }

    public function enviarMensagensLogs(string $telefone, string $mensagem): string
    {
        $resposta = Http::post($this->endpoint, [
            'message' => [
                'api_key_app'   => $this->apiKey,
                'phone_number'  => $telefone,
                'message_body'  => $mensagem,
            ]
        ]);

        $status = str_replace(' ', '', explode('-', $resposta['status'])[0]);

        return $status;
        // return match ($status) {
        //     '200' => 'Mensagem enviada com sucesso.',
        //     '404' => 'Saldo insuficiente.',
        //     '500' => 'Provedor indisponível.',
        //     default => 'Erro desconhecido. Verifique a API Key ou dados enviados.',
        // };
    }

    public function enviarMensagem(string $telefone, string $mensagem){
        $smsLog = new SmsLogs();
        $smsLog->telefone = $telefone;
        $smsLog->mensagem = $mensagem;
        
        try {           

            $status = $this->enviarMensagensLogs($smsLog->telefone, $smsLog->mensagem);

            // Interpreta o status retornado pela API
            $resposta = match ($status) {
                '200' => 'Mensagem enviada com sucesso.',
                '404' => 'Saldo insuficiente.',
                '500' => 'Provedor indisponível.',
                default => 'Erro desconhecido.',
            };

            // Define o estado com base na resposta
            $smsLog->estado = $status === '200' ? 1 : 2;
            $smsLog->resposta_API = $resposta;
            if($status === '200'){
                $smsLog->enviado_em = DataGeneral::dataHoraActual();
            }else{
                $smsLog->data_tentativa = DataGeneral::dataHoraActual();
            }                
            $smsLog->tentativas += 1;
            $smsLog->save();

        } catch (\Exception $e) {
            $smsLog->estado = 2;
            $smsLog->tentativas += 1;
            $smsLog->data_tentativa = DataGeneral::dataHoraActual();
            $smsLog->erro = $e->getMessage();
            $smsLog->save();
        }

    }
}
