<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('noticias', function (Blueprint $table) {
            $table->id();
            $table->string('titulo'); 
            $table->date('data_publicacao');
            $table->text('resumo'); 
            $table->string('imagem')->nullable(); 
            $table->longText('corpo_noticia'); 
            $table->integer('destaque')->default(0); 
            $table->integer('estado')->default(0); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('noticias');
    }
};
