<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('contacto_admins', function (Blueprint $table) {
            $table->id();
            $table->string('endereco')->nullable();
            $table->string('email')->unique();
            $table->string('telefone')->unique();
            $table->string('horario')->nullable();
            $table->string('atendimento_de'); 
            $table->string('atendimento_para'); 
            $table->integer('estado')->default(0);
            $table->timestamps(); 
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contacto_admins');
    }
};
