
document.addEventListener("DOMContentLoaded", function() {
    // Função para validar os campos da aba atual
    function validateFields(tab) {
        const inputs = tab.querySelectorAll('input, select');
        let isValid = true;
        inputs.forEach(input => {
        if (!input.checkValidity() || input.value.trim() === '') {
            isValid = false;
            input.classList.add('is-invalid');
        } else {
            input.classList.remove('is-invalid');
        }
        });
        return isValid;
    }
    // Função para avançar para a próxima aba
    document.querySelectorAll('.nexttab').forEach(button => {
        button.addEventListener('click', function() {
        const currentTab = document.querySelector('.tab-pane.show.active');
        if (validateFields(currentTab)) {
            const nextTabId = this.getAttribute('data-nexttab');
            const nextTabActive = nextTabId.replace("-tab", "");
            const nextTabIdActive = document.getElementById(nextTabActive);
            const nextTab = document.getElementById(nextTabId);
            if (nextTab) {
            // Remove a classe 'active' da aba atual
            currentTab.classList.remove('show', 'active');
            currentTab.classList.add('fade'); // Adiciona a classe 'fade' para animação de transição
            // Adiciona a classe 'active' à próxima aba
            nextTab.classList.add('show', 'active');
            nextTab.classList.add('fade'); // Adiciona a classe 'fade' para animação de transição
            nextTabIdActive.classList.add('show', 'active');
            // Ativa o botão da próxima aba
            document.querySelector(`button[data-previous="${currentTab.id}-tab"]`).classList.add('active');
            // Desativa o botão da aba atual
            this.classList.remove('active');
            }
        }
        });
    });
    // Função para voltar à aba anterior
    document.querySelectorAll('.previestab').forEach(button => {
        button.addEventListener('click', function() {
        const currentTab = document.querySelector('.tab-pane.show.active');
        if (validateFields(currentTab)) {
            const previousTabId = this.getAttribute('data-previous');
            const previousTabIdActive = previousTabId.replace("-tab", "");
            const previousTabActive = document.getElementById(previousTabIdActive);
            const previousTab = document.getElementById(previousTabId);
            if (previousTab) {
            // Remove a classe 'show' e 'active' da aba atual
            currentTab.classList.remove('show', 'active');
            currentTab.classList.add('fade'); // Adiciona a classe 'fade' para animação de transição
            // Adiciona a classe 'show' e 'active' à aba anterior
            previousTabActive.classList.add('show', 'active');
            previousTab.classList.add('show', 'active');
            previousTab.classList.add('fade'); // Adiciona a classe 'fade' para animação de transição
            // Ativa o botão da aba anterior e desativa o botão da aba atual
            this.classList.remove('active');
            document.querySelector(`button[data-nexttab="${previousTab.id}-tab"]`).classList.add('active');
            }
        }
        });
    });
});
