
// Método de add campo de contacto.
document.addEventListener("DOMContentLoaded", function() {
  // Função para validar os campos da aba atual
  function validateFields(tab) {
      const inputs = tab.querySelectorAll('input, select');
      let isValid = true;
      inputs.forEach(input => {
      if (!input.checkValidity()) {
          isValid = false;
          input.classList.add('is-invalid');
      } else {
          input.classList.remove('is-invalid');
      }
      });
      return isValid;
  }
  // Função para avançar para a próxima aba
  document.querySelectorAll('.nexttab').forEach(button => {
      button.addEventListener('click', function() {
      const currentTab = document.querySelector('.tab-pane.show.active');
      if (validateFields(currentTab)) {
          const nextTabId = this.getAttribute('data-nexttab');
          const nextTabActive = nextTabId.replace("-tab", "");
          const nextTabIdActive = document.getElementById(nextTabActive);
          const nextTab = document.getElementById(nextTabId);
          if (nextTab) {
          // Remove a classe 'active' da aba atual
          currentTab.classList.remove('show', 'active');
          currentTab.classList.add('fade'); // Adiciona a classe 'fade' para animação de transição
          // Adiciona a classe 'active' à próxima aba
          nextTab.classList.add('show', 'active');
          nextTab.classList.add('fade'); // Adiciona a classe 'fade' para animação de transição
          nextTabIdActive.classList.add('show', 'active');
          // Ativa o botão da próxima aba
          document.querySelector(`button[data-previous="${currentTab.id}-tab"]`).classList.add('active');
          // Desativa o botão da aba atual
          this.classList.remove('active');
          }
      }
      });
  });
  // Função para voltar à aba anterior
  document.querySelectorAll('.previestab').forEach(button => {
      button.addEventListener('click', function() {
      const currentTab = document.querySelector('.tab-pane.show.active');
      if (validateFields(currentTab)) {
          const previousTabId = this.getAttribute('data-previous');
          const previousTabIdActive = previousTabId.replace("-tab", "");
          const previousTabActive = document.getElementById(previousTabIdActive);
          const previousTab = document.getElementById(previousTabId);
          if (previousTab) {
          // Remove a classe 'show' e 'active' da aba atual
          currentTab.classList.remove('show', 'active');
          currentTab.classList.add('fade'); // Adiciona a classe 'fade' para animação de transição
          // Adiciona a classe 'show' e 'active' à aba anterior
          previousTabActive.classList.add('show', 'active');
          previousTab.classList.add('show', 'active');
          previousTab.classList.add('fade'); // Adiciona a classe 'fade' para animação de transição
          // Ativa o botão da aba anterior e desativa o botão da aba atual
          this.classList.remove('active');
          document.querySelector(`button[data-nexttab="${previousTab.id}-tab"]`).classList.add('active');
          }
      }
      });
  });
});

// document.addEventListener("DOMContentLoaded", function () {
//     const addContactBtn = document.getElementById("add-contacto-btn");
//     const removeContactBtn = document.getElementById("remove-contacto-btn");
//     const contactContainer = document.getElementById("contactos-container");
//     const addCocumenctBtn = document.getElementById("add-documento-btn");
//     const removeDocumentBtn = document.getElementById("remove-documento-btn");
//     const documentContainer = document.getElementById("documentos-container");
//     const addContaBtn = document.getElementById("add-conta-btn");
//     const removeContaBtn = document.getElementById("remove-conta-btn");
//     const contaContainer = document.getElementById("contas-container");

//     let contaIndex = 1;
//     let contactIndex = 1;
//     let documentIndex = 1;

//     addContactBtn.addEventListener('click', function () {
//       const newContact = document.createElement('div');
//       newContact.className = 'contacto mb-3';
//       newContact.innerHTML = `
//         <h3>${contactIndex+1}º Contacto</h3>
//         <div class="mb-3">
//           <label class="form-label" for="tipo-contacto-select-${contactIndex+1}">Tipo de Contacto</label>
//           <select class="form-select tipo-contacto-select" name="TipoContacto${contactIndex}" id="tipo-contacto-select-${contactIndex+1}">
//             <option value="">Selecione um tipo</option>
//             <option value=1>Telefone</option>
//             <option value=3>Telemovel</option>
//             <!-- Adicione outros tipos de contacto conforme necessário -->
//           </select>
//           <div class="invalid-feedback">Por favor, selecione o tipo de contacto</div>
//         </div>
//         <div class="mb-3">
//           <label class="form-label" for="contacto-input-${contactIndex+1}">Contacto</label>
//           <input type="text" class="form-control contacto-input" name="contacto${contactIndex}" id="contacto-input-${contactIndex+1}" placeholder="Digite o contacto" maxlength="50">
//           <div class="invalid-feedback">Por favor, preencha o contacto</div>
//           <span id="contacto-input-${contactIndex} Aviso" class="text-danger d-none">Por favor, Informe uma contacto válida...</span>
//         </div>
//       `;
//       contactIndex++;
//       contactContainer.appendChild(newContact);
//     });

//     removeContactBtn.addEventListener("click", function () {
//         if (contactContainer.children.length > 1) {
//             contactContainer.removeChild(contactContainer.lastChild);
//             contactIndex--;
//         }
//     });

//     /**
//      * evento que adiciona mais campos para novos documentos
//      */

//     // addCocumenctBtn.addEventListener('click', function () {
//     //   const newDocument = document.createElement('div');
//     //   newDocument.className = 'documento';
//     //   newDocument.innerHTML = `
//     //     <h3>${documentIndex+1}º Documento</h3>
//     //     <div class="row mb-3">
//     //       <!-- Tipo de Documento -->
//     //       <div class="col-md-6">
//     //         <label class="form-label" for="tipo-documento-select-${documentIndex+1}">Tipo de Documento</label>
//     //         <select class="form-select" id="tipo-documento-select-${documentIndex+1}" name="TipoDocumento_id${documentIndex}" >
//     //           <option selected disabled value="">Seleccione uma</option>
//     //           <option value=1>Cédula</option>
//     //           <option value=2>BI</option>
//     //           <option value=3>Passaporte</option>
//     //           <option value=4>Cartão de Contribuinte</option>
//     //         </select>
//     //       <div class="invalid-feedback">Por favor, selecione o tipo de documento</div>
//     //     </div>

//     //       <!-- Número do Documento -->
//     //       <div class="col-md-6">
//     //         <label class="form-label" for="numero-documento-input-${documentIndex+1}">Número do Documento</label>
//     //         <input type="text" class="form-control" id="numero-documento-input-${documentIndex+1}" value=""
//     //             placeholder="Digite o número do documento" name="n_identificacao${documentIndex}" maxlength="30">
//     //         <div class="invalid-feedback">Por favor, preencha o número do documento</div>
//     //         <span id="numero-documentoAviso" class="text-danger d-none">Por favor, Informe um Número de Documento válido...</span>
//     //       </div>
//     //     </div>

//     //     <div class="row mb-3">
//     //       <!-- Data de Emissão -->
//     //       <div class="col-md-6">
//     //         <label class="form-label" for="data-emissao-input-${documentIndex+1}">Data de Emissão</label>
//     //         <input type="date" class="form-control" id="data-emissao-input-${documentIndex+1}" name="data_emissao${documentIndex}" value="">
//     //         <div class="invalid-feedback">Por favor, selecione a data de emissão</div>
//     //       </div>

//     //       <!-- Data de Expiração -->
//     //       <div class="col-md-6">
//     //         <label class="form-label" for="data-expiracao-input-1">Data de Expiração</label>
//     //         <input type="date" class="form-control" id="data-expiracao-input-${documentIndex+1}" name="data_expiracao${documentIndex}" value="" >
//     //         <div class="invalid-feedback">Por favor, selecione a data de expiração</div>
//     //         <span id="data-expiracaoAviso" class="text-danger d-none">Por favor, Informe uma Data válida...</span>
//     //       </div>
//     //     </div>

//     //     <!-- Local de Emissão -->
//     //     <div class="mb-3">
//     //       <label class="form-label" for="local-emissao-input-${documentIndex+1}">Local de Emissão</label>
//     //       <input type="text" class="form-control" id="local-emissao-input-${documentIndex+1}" value=""
//     //       placeholder="Digite o local de emissão" name="local_emissao${documentIndex+1}" oninput="formatarText(this)" maxlength="30">
//     //       <div class="invalid-feedback">O local não deve conter caracteres especiais(Exceto os acentos) e 4 letras no minimo!</div>
//     //     </div>
//     //   `;
//     //   documentIndex++;
//     //   documentContainer.appendChild(newDocument);
//     // });

//     // removeDocumentBtn.addEventListener("click", function () {
//     //     if (documentContainer.children.length > 1) {
//     //         documentContainer.removeChild(documentContainer.lastChild);
//     //         documentIndex--;
//     //     }
//     // });


//     function validateContactInput() {
//         let isValid = true;
//         const contactTypeSelects = document.querySelectorAll(
//             ".tipo-contacto-select"
//         );
//         const contactInputs = document.querySelectorAll(".contacto-input");

//         contactTypeSelects.forEach((select, index) => {
//             if (select.value === "") {
//                 select.classList.add("is-invalid");
//                 isValid = false;
//             } else {
//                 select.classList.remove("is-invalid");
//             }
//         });

//         contactInputs.forEach((input, index) => {
//             const contactType = contactTypeSelects[index].value;
//             const contactValue = input.value.trim();
//             if (contactValue === "") {
//                 input.classList.add("is-invalid");
//                 isValid = false;
//             } else {
//                 input.classList.remove("is-invalid");
//             }
//         });

//         return isValid;
//     }
// });

function popularMunicipios(provinciaId) {

  const selectMunicipio = document.getElementById('Municipio');
  selectMunicipio.innerHTML = '';

  $.ajax({
    url: "/OlimpoWeb/public/provincias/" + provinciaId + "/municipios",
    // url: "/provincias/" + provinciaId + "/municipios",
    type: "GET",
    dataType: "json",

    success: function (data) {
        //console.log(data);
      console.log(data.municipios[0].nome)
      //die(provinciaId);
      if (data.municipios.length != 0) {
        console.log(data.municipios[0]);

        for (let i = 0; i < data.municipios.length; i++){
            //die('ola');
            const option = document.createElement('option');
            option.value = data.municipios[i].id;
            option.text = data.municipios[i].nome;
            selectMunicipio.appendChild(option);
        }

      } else {
        const option = document.createElement('option');
        option.value = '';
        option.text = 'Selecione uma provincia primeiro';
        selectMunicipio.appendChild(option);
      }
    },
  });

}

const selectProvincia = document.getElementById('Provincia');
selectProvincia.addEventListener('change', function() {
  const provinciaId = this.value;
  console.log(provinciaId);

  //alert('Provincia Selecionado--',provinciaId)
  popularMunicipios(provinciaId);
});

function formatarIBAN(element) {
  // Remove todos os caracteres que não sejam números ou pontos
  let valor = element.value.replace(/[^0-9.]/g, '');
  // Formata a entrada em grupos de 4 dígitos, separados por ponto
  const partes = valor.split('.').join('').match(/.{1,4}/g); // Divide em grupos de 4
  if (partes) {
      valor = partes.join('.'); // Junta com ponto
  }
  // Atualiza o campo com o valor formatado
  element.value = valor;
}

function formatarValor(element) {
    // Remove todos os caracteres que não sejam números
    let valor = element.value.replace(/\D/g, '');

    // Verifica se o valor é um número válido
    if (isNaN(valor) || valor === '') {
      element.setCustomValidity(" ");
      element.reportValidity();
    }
}
/*
$(document).ready(function() {
    $('#provincia-select').on('change', function() {
    var Provincia = this.value;
    $("#municipio-select").html('');
    $.ajax({
    url:"{{url('get-municipios')}}",
    type: "POST",

    data: {
     Provincia: Provincia,
    _token: '{{csrf_token()}}'

    },
    dataType : 'json',
    success: function(result){
    $('#municipio-select').html('<option value="">Escolhe o Municipio</option>');
    $.each(result.municipios,function(key,value){
        alert('Provincia Selecionado--',result.municipios)
    $("#municipio-select").append('<option value="'+value.id+'">'+value.nome+'</option>');
    });alert('Provincia Selecionado--',result.municipios)
    $('#municipio-select').html('<option value="">Escolhe Primeiro a Provincia</option>');
    }
    });
    });


});*/
