
///////////////////////////////////// EXPRESSOES //////////////////////////////////
const validaTextoComCaracteresEspeciais =
  /^[A-Za-zÀ-ÿ\u00f1\u00d1]+(?:[\s'-][A-Za-zÀ-ÿ\u00f1\u00d1]+)*$/;
const validaNIFColetivoAngolano = /^\d{10}$/;
const validaEmail = /^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\.[a-zA-Z]{2,}$/;
const validaNumeroDeTelefone =
  /^((\+244[9]{1}[0-9]{8})|(\+244[222]{3}[0-9]{6})|([9]{1}[0-9]{8})|([222]{3}[0-9]{6})|(\+\d{1,3}[1-9]\d{0,14}))$/;
const validaNumeroMecanograficoEDeAssociado =  /^[0-9][0-9]{0,8}$/

////////////////////////////////// Funcoes auxiliares //////////////////////////////////
function formatarIBAN(element) {
  // Remove todos os caracteres que não sejam números ou pontos
  let valor = element.value.replace(/[^0-9.]/g, '');
  // Formata a entrada em grupos de 4 dígitos, separados por ponto
  const partes = valor.split('.').join('').match(/.{1,4}/g); // Divide em grupos de 4
  if (partes) {
    valor = partes.join('.'); // Junta com ponto
  }
  // Atualiza o campo com o valor formatado
  element.value = valor;
}

function validarNumeros(element) {
  if (!validaNumeroMecanograficoEDeAssociado.test(element.value) || element.value.length < 5) {
    element.setCustomValidity("O número Mecanografico deve ter no minimo 5 digitos");
    element.reportValidity();
  } else {
    element.setCustomValidity("");
  }
}

function validarNIF(element) {
  if (!validaNIFColetivoAngolano.test(element.value) || element.value.length < 10) {
    element.setCustomValidity("O NIF deve ter 10 digitos!");
    element.reportValidity();
  } else {
    element.setCustomValidity("");
  }
}

function formatarText(element) {
  let nomeSemEspaco = element.value.trim();
  if (nomeSemEspaco.length < 4) {
    element.setCustomValidity("Este campo deve ter no minino 4 caracteres! ");
    element.reportValidity();
  } else {
    element.setCustomValidity("");
  }
}


function formatarSalario(element) {
  // Remove todos os caracteres que não sejam números
  let valor = element.value.replace(/\D/g, '');

  // Verifica se o valor é um número válido
  if (isNaN(valor) || valor === '') {
      element.setCustomValidity(" ");
      element.reportValidity();
  }

  // Adiciona as casas decimais
  valor = (valor / 100).toFixed(2) + '';


  element.setCustomValidity("");
  element.value = valor;
}



///////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////// VALIDACOES //////////////////////////////////


const email = document.getElementById("email-input");


email.onkeyup = function () {
  if (!validaEmail.test(email.value)) {
    email.setCustomValidity("E-mail inválido...");
    email.reportValidity();
  } else {
    email.setCustomValidity("");
  }
};


///////////////////////// Validacao de ate 5 documentos //////////////////////////////////
///////////////////////// Documentos de Identificação - 1 //////////////////////////////////
const numero_documento1 = document.getElementById("numero-documento-input-1");
const data_emissao1 = document.getElementById("data-emissao-input-1");
const data_expiracao1 = document.getElementById("data-expiracao-input-1");

//let validaNumeroDoDocumentoDeIdentificacao1 = ''

document.body.addEventListener('change', function (event) {

  if (event.target.id === 'tipo-documento-select-1') {
    let validaNumeroDoDocumentoDeIdentificacao1 = ''
    const valorSelecionado = event.target.value;


    const numero_documento1 = document.getElementById("numero-documento-input-1");
    console.log(valorSelecionado)
    // Verifica o valor usando switch
    switch (valorSelecionado) {
      case "5":
        validaNumeroDoDocumentoDeIdentificacao1 = validaNIFColetivoAngolano;
        if (!validaNumeroDoDocumentoDeIdentificacao1.test(numero_documento1.value) && numero_documento1.value || numero_documento1.value.length < 10) {
          numero_documento1.setCustomValidity("O número do documento não corresponde ao tipo ");
          numero_documento1.reportValidity();
        } else {
          numero_documento1.setCustomValidity("");
        }
        break;
      default:
        validaNumeroDoDocumentoDeIdentificacao1 = validaTextoComCaracteresEspeciais;
        console.log('Nenhum documento selecionado correspondente');
    }

    numero_documento1.onkeyup = function () {
      if (!validaNumeroDoDocumentoDeIdentificacao1.test(numero_documento1.value)) {
        numero_documento1.setCustomValidity("O número do documento não corresponde ao tipo seleccionado! ");
        numero_documento1.reportValidity();
      } else {
        numero_documento1.setCustomValidity("");
      }
    }
  }

  if (event.target.id === 'data-emissao-input-1' || event.target.id === 'data-expiracao-input-1') {
    document.getElementById('data-emissao-input-1').addEventListener('change', function() {
      const dataEmissao = new Date(this.value);

      if (isNaN(dataEmissao)) {
        return; // Se a data for inválida, não faz nada
      }
      const dataExpiracaoInput = document.getElementById('data-expiracao-input-1');
      // Adicionar 5 anos à data de emissão
      const dataExpiracaoMin = new Date(dataEmissao);
      dataExpiracaoMin.setFullYear(dataExpiracaoMin.getFullYear() + 5);
      // Formatando a data no formato YYYY-MM-DD para o campo de input
      const dataExpiracaoMinFormatada = dataExpiracaoMin.toISOString().split('T')[0];
      // Definir o valor mínimo no campo de expiração
      dataExpiracaoInput.min = dataExpiracaoMinFormatada;
      dataExpiracaoInput.value = "";
    });
  }

});

///////////////////////// Documentos de Identificação - 5 //////////////////////////////////
document.body.addEventListener('change', function (event) {
  if (event.target.id === 'tipo-contacto-select-2') {
    let validaContacto2 = ''
    const valorSelecionado = event.target.value;


    const contacto2 = document.getElementById("contacto-input-2");

    // Verifica o valor usando switch
    switch (valorSelecionado) {
      case "1":
        validaContacto2 = validaNumeroDeTelefone
        if (!validaContacto2.test(contacto2.value) && contacto2.value) {
          contacto2.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
          contacto2.reportValidity();
          } else {
            contacto2.setCustomValidity("");
          }
        break;
      case "2":
        validaContacto2 = validaEmail
        if (!validaContacto2.test(contacto2.value) && contacto2.value) {
          contacto2.setCustomValidity("O E-mail não corresponde ao tipo Selecionado!");
          contacto2.reportValidity();
          } else {
            contacto2.setCustomValidity("");
          }
        break;
      case "3":
        validaContacto2 = validaNumeroDeTelefone
        if (!validaContacto2.test(contacto2.value) && contacto2.value) {
          contacto2.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
          contacto2.reportValidity();
          } else {
            contacto2.setCustomValidity("");
          }
        break;
      default:
        validaContacto2 = validaTextoComCaracteresEspeciais
        console.log('Nenhum documento selecionado correspondente');
    }

    contacto2.onkeyup = function () {
      if (!validaContacto2.test(contacto2.value)) {
        contacto2.setCustomValidity("O número do documento não corresponde ao tipo! ");
        contacto2.reportValidity();
      } else {
        contacto2.setCustomValidity("");
      }
    }
  }

});
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////// Documentos de Identificação - 5 //////////////////////////////////
document.body.addEventListener('change', function (event) {
  if (event.target.id === 'tipo-contacto-select-3') {
    let validaContacto3 = ''
    const valorSelecionado = event.target.value;


    const contacto3 = document.getElementById("contacto-input-3");

    // Verifica o valor usando switch
    switch (valorSelecionado) {
      case "1":
        validaContacto3 = validaNumeroDeTelefone
        if (!validaContacto3.test(contacto3.value) && contacto3.value) {
          contacto3.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
          contacto3.reportValidity();
          } else {
            contacto3.setCustomValidity("");
          }
        break;
      case "2":
        validaContacto3 = validaEmail
        if (!validaContacto3.test(contacto3.value) && contacto3.value) {
          contacto3.setCustomValidity("O E-mail não corresponde ao tipo Selecionado!");
          contacto3.reportValidity();
          } else {
            contacto3.setCustomValidity("");
          }
        break;
      case "3":
        validaContacto3 = validaNumeroDeTelefone
        if (!validaContacto3.test(contacto3.value) && contacto3.value) {
          contacto3.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
          contacto3.reportValidity();
          } else {
            contacto3.setCustomValidity("");
          }
        break;
      default:
        validaContacto3 = validaTextoComCaracteresEspeciais
        console.log('Nenhum documento selecionado correspondente');
    }

    contacto3.onkeyup = function () {
      if (!validaContacto3.test(contacto3.value)) {
        contacto3.setCustomValidity("O número do documento não corresponde ao tipo! ");
        contacto3.reportValidity();
      } else {
        contacto3.setCustomValidity("");
      }
    }
  }

});
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////// Documentos de Identificação - 5 //////////////////////////////////
document.body.addEventListener('change', function (event) {
  if (event.target.id === 'tipo-contacto-select-4') {
    let validaContacto4 = ''
    const valorSelecionado = event.target.value;


    const contacto4 = document.getElementById("contacto-input-4");

    // Verifica o valor usando switch
    switch (valorSelecionado) {
      case "1":
        validaContacto4 = validaNumeroDeTelefone
        if (!validaContacto4.test(contacto4.value) && contacto4.value) {
          contacto4.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
          contacto4.reportValidity();
          } else {
            contacto4.setCustomValidity("");
          }
        break;
      case "2":
        validaContacto4 = validaEmail
        if (!validaContacto4.test(contacto4.value) && contacto4.value) {
          contacto4.setCustomValidity("O E-mail não corresponde ao tipo Selecionado!");
          contacto4.reportValidity();
          } else {
            contacto4.setCustomValidity("");
          }
        break;
      case "3":
        validaContacto4 = validaNumeroDeTelefone
        if (!validaContacto4.test(contacto4.value) && contacto4.value) {
          contacto4.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
          contacto4.reportValidity();
          } else {
            contacto4.setCustomValidity("");
          }
        break;
      default:
        validaContacto4 = validaTextoComCaracteresEspeciais
        console.log('Nenhum documento selecionado correspondente');
    }

    contacto4.onkeyup = function () {
      if (!validaContacto4.test(contacto4.value)) {
        contacto4.setCustomValidity("O número do documento não corresponde ao tipo! ");
        contacto4.reportValidity();
      } else {
        contacto4.setCustomValidity("");
      }
    }
  }

});
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////// Documentos de Identificação - 5 //////////////////////////////////
document.body.addEventListener('change', function (event) {
  if (event.target.id === 'tipo-contacto-select-5') {
    let validaContacto5 = ''
    const valorSelecionado = event.target.value;


    const contacto5 = document.getElementById("contacto-input-5");

    // Verifica o valor usando switch
    switch (valorSelecionado) {
      case "1":
        validaContacto5 = validaNumeroDeTelefone
        if (!validaContacto5.test(contacto5.value) && contacto5.value) {
          contacto5.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
          contacto5.reportValidity();
          } else {
            contacto5.setCustomValidity("");
          }
        break;
      case "2":
        validaContacto5 = validaEmail
        if (!validaContacto5.test(contacto5.value) && contacto5.value) {
          contacto5.setCustomValidity("O E-mail não corresponde ao tipo Selecionado!");
          contacto5.reportValidity();
          } else {
            contacto5.setCustomValidity("");
          }
        break;
      case "3":
        validaContacto5 = validaNumeroDeTelefone
        if (!validaContacto5.test(contacto5.value) && contacto5.value) {
          contacto5.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
          contacto5.reportValidity();
          } else {
            contacto5.setCustomValidity("");
          }
        break;
      default:
        validaContacto5 = validaTextoComCaracteresEspeciais
        console.log('Nenhum documento selecionado correspondente');
    }

    contacto5.onkeyup = function () {
      if (!validaContacto5.test(contacto5.value)) {
        contacto5.setCustomValidity("O número do documento não corresponde ao tipo! ");
        contacto5.reportValidity();
      } else {
        contacto5.setCustomValidity("");
      }
    }
  }

});
///////////////////////////////////////////////////////////////////////////////////////////

///////////////////////// Documentos de Identificação - 5 //////////////////////////////////
document.body.addEventListener('change', function (event) {
  if (event.target.id === 'tipo-contacto-select-6') {
    let validaContacto6 = ''
    const valorSelecionado = event.target.value;


    const contacto6 = document.getElementById("contacto-input-6");

    // Verifica o valor usando switch
    switch (valorSelecionado) {
      case "1":
        validaContacto6 = validaNumeroDeTelefone
        if (!validaContacto6.test(contacto6.value) && contacto6.value) {
          contacto6.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
          contacto6.reportValidity();
          } else {
            contacto6.setCustomValidity("");
          }
        break;
      case "2":
        validaContacto6 = validaEmail
        if (!validaContacto6.test(contacto6.value) && contacto6.value) {
          contacto6.setCustomValidity("O E-mail não corresponde ao tipo Selecionado!");
          contacto6.reportValidity();
          } else {
            contacto6.setCustomValidity("");
          }
        break;
      case "3":
        validaContacto6 = validaNumeroDeTelefone
        if (!validaContacto6.test(contacto6.value) && contacto6.value) {
          contacto6.setCustomValidity("O contacto não corresponde ao tipo Selecionado!");
          contacto6.reportValidity();
          } else {
            contacto6.setCustomValidity("");
          }
        break;
      default:
        validaContacto6 = validaTextoComCaracteresEspeciais
        console.log('Nenhum documento selecionado correspondente');
    }

    contacto6.onkeyup = function () {
      if (!validaContacto6.test(contacto6.value)) {
        contacto6.setCustomValidity("O número do documento não corresponde ao tipo! ");
        contacto6.reportValidity();
      } else {
        contacto6.setCustomValidity("");
      }
    }
  }

});
///////////////////////////////////////////////////////////////////////////////////////////
