var checkAll = document.getElementById("checkTodos");
var todosCheck = document.querySelectorAll('.form-check-todos input[type="checkbox"]');
var select_periodo = document.getElementById('select_periodo');
var btn_solicitar = document.getElementById('btn_solicitar');

var mensagens_erro = document.getElementById('mensagens_erro');
var mensagens_sucesso = document.getElementById('mensagens_sucesso');

var listaIds = [];
var qtdTodosCheck = todosCheck.length;


var url = "";
var urlAjaxstore = "";

function construct(url,urlAjaxstore) {
    this.url = url;
    this.urlAjaxstore = urlAjaxstore;
    //alert(url);
}

select_periodo.addEventListener('change', ev => {

    listaIds = [];
    document.getElementById('listaVazia').innerHTML = '';
    $("#corpo_tabela").empty();

    ev.preventDefault();
    var CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
    $.ajax({

        url: url  + "?periodo=" + ev.target.value,
        type: "GET",
        dataType: "json",
        success: function (data) {_token: CSRF_TOKEN
            console.log(data);

            let associados = data.associados;
            let valores = data.valores;
            for (let i = 0; i < associados.length; i++) {
                let linha = document.createElement('tr');
                linha.classList.add('table-active');

                linha.innerHTML = `
                    <th scope="row">
                        <div class="form-check">
                            <input class="form-check-input item-checkbox" type="checkbox" name="check${associados[ i ].id}" value="${associados[ i ].id}">
                        </div>
                    </th>
                    <td class="text-center id">${ i+1 }</td>
                    <td class="customer_name">${ associados[ i ].nome ?? '----' }</td>
                    <td class="text-center email">${ valores[ i ].total ? formatarValor(valores[ i ].total) : '----' }</td>
                    <td class="text-center phone">${ valores[ i ].parcela_fixa ? formatarValor(valores[ i ].valor_global) : '----' }</td>
                    <td class="text-center date">${ valores[ i ].quota_mensal ? formatarValor(valores[ i ].quota_mensal) : '----' }</td>
                    <td class="text-center phone">${ valores[ i ].valor_taxa_irt ? formatarValor(valores[ i ].valor_taxa_irt) : '----' }</td>
                    <td class="text-center phone">${ valores[ i ].taxa_irt ? formatarValor(valores[ i ].taxa_irt) : '----' }</td>
                `;

                $("#corpo_tabela").append(linha);

            }

        },
        error: function (data,CSRF_TOKEN) {
            console.log(data,CSRF_TOKEN);
        },
        beforeSend: function () {},
        complete: function () {},
    });

});

// Instrucao de eventos para capturar mudanças nos checkboxes adicionados dinamicamente
$("#corpo_tabela").on("change", ".item-checkbox", function() {
    const isChecked = $(this).is(":checked");
    const itemId = $(this).val();

    // Manipulação específica para quando o checkbox é clicado
    if(!isChecked) {
        listaIds = listaIds.filter((id) => {
            if(itemId != id ) return id;
            else false;
        });
    }else{
        listaIds.push(itemId);
    }

    console.log(listaIds);

    // Aqui pode adicionar outras ações, como enviar o estado do checkbox para o servidor ou atualizar outro elemento da interface. // Verifica se todos os checkboxes estão selecionados ou não para definir o estado do "Selecionar Todos"
    const allChecked = $("#corpo_tabela .item-checkbox").length === $("#corpo_tabela .item-checkbox:checked").length;
    $("#checkTodos").prop("checked", allChecked);
});

$("#checkTodos").on("click", function() {
    // Verifica se o checkbox de selecionar todos está marcado
    const isChecked = $(this).is(":checked");

    // Define o estado de todos os checkboxes da tabela para o mesmo estado
    $("#corpo_tabela .form-check-input").prop("checked", isChecked);

    listaIds = [];
    listaIds = gerarListaCheckboxesSelecionados();
    console.log("Valores dos checkboxes selecionados:", listaIds);
});

btn_solicitar.addEventListener( 'click', e => {

    if(listaIds.length==0){
        console.log('Amem, tou vivo');
        acionarModal('ModalCheckSomeSelect') /*alert('Nenhum associado foi seleccionado!!!')*/;
    }else {
        // /*acionarModal('')*/ confirm('Queres Realmente Solicitar Em Massa!!!');
        e.preventDefault();
        SolicitarSubsidioSuplementoRemoneratorioEmMassa();
    }

});

Array.from(todosCheck).forEach( function(item) {
    item.addEventListener('click', (ev2) => {
        if(ev2.target.checked == 1) ev2.target.closest("tr").classList.remove("table-active")
        listaIds = [];
        Array.from(todosCheck).forEach(function(check) {
            if(check.checked) listaIds.push(check.value);
        })
        console.log(listaIds);
    });
});

function SolicitarSubsidioSuplementoRemoneratorioEmMassa () {
    var CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
    $.ajax({
        url: urlAjaxstore +  "?associado_ids=" + listaIds.join(',') + "&periodo=" + select_periodo.value,
        type: "GET",
        dataType: "json",

        // url: `http://localhost/OlimpoWeb/public/comparticipacoes/processarSubsidioSuplementoRemoneratorio/store?associado_ids=${listaIds.join(',')}&periodo=${select_periodo.value}`,
        // type: "get",
        // dataType: "json",

        success: function (data,CSRF_TOKEN) {
            console.log(data);

            if(data.status){
                document.getElementById('mensagens_sucesso').innerHTML = data.mensagem;
                acionarModal('ModalProcessoSucesso');
            }
            else{
                document.getElementById('mensagens_erro').innerHTML = data.mensagem;
                acionarModal('ModalProcessoERRO');
            }

        },
        error: function (data) {
            console.log(data);
        },
        beforeSend: function () {},
        complete: function () {},
    });
}

function gerarListaCheckboxesSelecionados() {
    // Seleciona todos os checkboxes `.item-checkbox` que estão marcados no `#corpo_tabela`
    const checkboxesSelecionados = $("#corpo_tabela .item-checkbox:checked");

    // Array para armazenar os valores dos checkboxes selecionados
    const valoresSelecionados = [];

    // Itera sobre os checkboxes selecionados e adiciona o valor de cada um ao array
    checkboxesSelecionados.each(function() {
        valoresSelecionados.push($(this).val());
    });

    return valoresSelecionados;  // Retorna a lista com os valores dos checkboxes selecionados
}

function acionarModal (modal) {
    console.log(modal);
    $(`#${modal}`).modal('show');
};

function actualizarPagina(){
    window.location.reload();
}

function formatarValor (valor) {
    return new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(valor);
}

// select_periodo.addEventListener('change', ev => {

//     let corpo_tabela = document.getElementById('corpo_tabela');
//     corpo_tabela.innerHTML = '';

//     ev.preventDefault();

//     $.ajax({
//         url: `http://localhost/OlimpoWeb/public/comparticipacoes/processarSubsidioSuplementoRemoneratorio/carregar?periodo=${ev.target.value}`,
//         type: "get",
//         dataType: "json",
//         success: function (data) {
//             console.log(data);

//             let associados = data.associados;
//             let valores = data.valores;
//             for (let i = 0; i < associados.length; i++) {
//                 let linha = document.createElement('tr');
//                 linha.classList.add('table-active');

//                 let coluna = document.createElement('th');
//                 coluna.setAttribute('scope', 'row');
//                 let div = document.createElement('div');
//                 div.classList.add('form-check');
//                 let input = document.createElement('input');
//                 input.classList.add('form-check-input');
//                 input.setAttribute('type', 'checkbox');
//                 input.setAttribute('name', 'check'+associados[ i ].id);
//                 input.setAttribute('value', associados[ i ].id);
//                 div.appendChild(input);
//                 coluna.appendChild(div);
//                 linha.appendChild(coluna);

//                 coluna = document.createElement('td');
//                 coluna.classList.add('text-center');
//                 coluna.classList.add('id');
//                 coluna.innerHTML = i+1;
//                 linha.appendChild(coluna);

//                 coluna = document.createElement('td');
//                 coluna.classList.add('customer_name');
//                 coluna.innerHTML = associados[ i ].nome ?? '----';
//                 linha.appendChild(coluna);

//                 coluna = document.createElement('td');
//                 coluna.classList.add('text-center');
//                 coluna.classList.add('email');
//                 coluna.innerHTML = valores[ i ].total ?? '----';
//                 linha.appendChild(coluna);

//                 coluna = document.createElement('td');
//                 coluna.classList.add('text-center');
//                 coluna.classList.add('email');
//                 coluna.innerHTML = valores[ i ].taxa_irt ?? '----';
//                 linha.appendChild(coluna);

//                 coluna = document.createElement('td');
//                 coluna.classList.add('text-center');
//                 coluna.classList.add('email');
//                 coluna.innerHTML = valores[ i ].parcela_fixa ?? '----';
//                 linha.appendChild(coluna);

//                 coluna = document.createElement('td');
//                 coluna.classList.add('text-center');
//                 coluna.classList.add('email');
//                 coluna.innerHTML = valores[ i ].valor_taxa_irt ?? '----';
//                 linha.appendChild(coluna);

//                 coluna = document.createElement('td');
//                 coluna.classList.add('text-center');
//                 coluna.classList.add('email');
//                 coluna.innerHTML = valores[ i ].quota_mensal ?? '----';
//                 linha.appendChild(coluna);

//                 corpo_tabela.appendChild(linha);

//             }

//         },
//         error: function (data) {
//             console.log(data);
//         },
//         beforeSend: function () {},
//         complete: function () {},
//     });

// });


// checkAll.addEventListener( 'click', (ev) => {
//     console.log(qtdTodosCheck);
//     if (1 == ev.target.checked) {
//         listaIds = [];
//         Array.from(todosCheck).forEach(function(check) {
//             check.checked = !0,
//             check.closest("tr").classList.add("table-active")
//             listaIds.push(check.value);
//         })
//         console.log(listaIds);
//     } else {
//         listaIds = [];
//         Array.from(todosCheck).forEach(function(check) {
//             check.checked = !1,
//             check.closest("tr").classList.remove("table-active")
//         })
//         console.log(listaIds);
//     }

//     Array.from(todosCheck).forEach( function(item) {
//         item.addEventListener('click', (ev2) => {
//             if(ev2.target.checked == 1) ev2.target.closest("tr").classList.remove("table-active")
//             listaIds = [];
//             Array.from(todosCheck).forEach(function(check) {
//                 if(check.checked) listaIds.push(check.value);
//             })
//             console.log(listaIds);
//             if (listaIds.length != qtdTodosCheck) ev.target.checked = 0;
//             else  ev.target.checked = 1;
//         });
//     });
// });
