var todosCheck = document.querySelectorAll('.form-check-todos input[type="checkbox"]');
var select_periodo = document.getElementById('select_periodo');
var btn_aprovar_todos = document.getElementById('btn_aprovar_todos');
var btn_rejeitar_todos = document.getElementById('btn_rejeitar_todos');

var mensagens_erro = document.getElementById('mensagens_erro');
var mensagens_sucesso = document.getElementById('mensagens_sucesso');

var listaIds = [];
var qtdTodosCheck = todosCheck.length;


var urlCarregar = "";
var urlResposta = "";

function construct(urlCarregar, urlResposta, urlRespostaIndividual) {
    this.urlCarregar = urlCarregar;
    this.urlResposta = urlResposta;
    this.urlRespostaIndividual = urlRespostaIndividual;
}

select_periodo.addEventListener('change', ev => {

    listaIds = [];
    $("#corpo_tabela").empty();
    document.getElementById('listaVazia').innerHTML = '';

    ev.preventDefault();

    $.ajax({

        url: urlCarregar + "?periodo=" + ev.target.value,
        type: "GET",
        dataType: "json",
        success: function (data) {
            console.log(data);

            let associados = data.associados;
            let valores = data.valores;
            for (let i = 0; i < associados.length; i++) {
                let linha = document.createElement('tr');
                linha.classList.add('table-active');

                // this.value =new Intl.NumberFormat().format("valorlimite")

                linha.innerHTML = `

                    <th scope="row">
                        <div class="form-check">
                            <input class="form-check-input item-checkbox" type="checkbox" name="check${associados[ i ].id}" value="${associados[ i ].id}">
                        </div>
                    </th>
                    <td class="text-center id">${ i+1 }</td>
                    <td class="customer_name">${ associados[ i ].nome ?? '----' }</td>
                    <td class="text-center email">${ formatarValor(valores[ i ].total) }</td>
                    <td class="text-center phone">
                        <span class="badge bg-warning-subtle text-primary text-uppercase">Pendente</span>
                    </td>
                    <td style="display: flex; align-items: center; justify-content: center;">

                        <div class="edit" style="margin-right: 10px;">
                            <a href="${urlRespostaIndividual}?associado=${associados[ i ].id}&opcao=aprove&periodo=${select_periodo.value}" class="btn btn-sm btn-success edit-item-btn" id="aprovar_solicitacao" title="Aprovar esta Solicitação"><i class="ri-checkbox-line"></i></a>
                        </div>
                        <div class="remove">
                            <a href="${urlRespostaIndividual}?associado=${associados[ i ].id}&opcao=deny&periodo=${select_periodo.value}" class="btn btn-sm btn-danger remove-item-btn" id="rejeitar_solicitacao" title="Rejeitar esta Solicitação"><i class="ri-checkbox-indeterminate-line"></i></a>
                        </div>

                    </td>
                `;

                $("#corpo_tabela").append(linha);

            }

        },
        error: function (data) {
            console.log(data);
        },
        beforeSend: function () {},
        complete: function () {},
    });

});

// Instrucao de eventos para capturar mudanças nos checkboxes adicionados dinamicamente
$("#corpo_tabela").on("change", ".item-checkbox", function() {
    const isChecked = $(this).is(":checked");
    const itemId = $(this).val();

    // Manipulação específica para quando o checkbox é clicado
    if(!isChecked) {
        listaIds = listaIds.filter((id) => {
            if(itemId != id ) return id;
            else false;
        });
    }else{
        listaIds.push(itemId);
    }

    console.log(listaIds);

    // Aqui pode adicionar outras ações, como enviar o estado do checkbox para o servidor ou atualizar outro elemento da interface. // Verifica se todos os checkboxes estão selecionados ou não para definir o estado do "Selecionar Todos"
    const allChecked = $("#corpo_tabela .item-checkbox").length === $("#corpo_tabela .item-checkbox:checked").length;
    $("#checkTodos").prop("checked", allChecked);
});

$("#checkTodos").on("click", function() {
    // Verifica se o checkbox de selecionar todos está marcado
    const isChecked = $(this).is(":checked");

    // Define o estado de todos os checkboxes da tabela para o mesmo estado
    $("#corpo_tabela .form-check-input").prop("checked", isChecked);

    listaIds = [];
    listaIds = gerarListaCheckboxesSelecionados();
    console.log("Valores dos checkboxes selecionados:", listaIds);
});

Array.from(todosCheck).forEach( function(item) {
    item.addEventListener('click', (ev2) => {
        if(ev2.target.checked == 1) ev2.target.closest("tr").classList.remove("table-active")
        listaIds = [];
        Array.from(todosCheck).forEach(function(check) {
            if(check.checked) listaIds.push(check.value);
        })
        console.log(listaIds);
    });
});

btn_aprovar_todos.addEventListener( 'click', e => {

    if(listaIds.length==0) acionarModal('ModalCheckSomeSelect') /*alert('Nenhum associado foi seleccionado!!!')*/;
    else {
        e.preventDefault();
        ResponderSubsidioSuplementoRemoneratorioEmMassa('aprove', select_periodo.value);
    }

});

btn_rejeitar_todos.addEventListener( 'click', e => {

    if(listaIds.length==0) acionarModal('ModalCheckSomeSelect') /*alert('Nenhum associado foi seleccionado!!!')*/;
    else {
        e.preventDefault();
        ResponderSubsidioSuplementoRemoneratorioEmMassa('deny', select_periodo.value);
    }

});

function gerarListaCheckboxesSelecionados() {
    const checkboxesSelecionados = $("#corpo_tabela .item-checkbox:checked");

    const valoresSelecionados = [];

    checkboxesSelecionados.each(function() {
        valoresSelecionados.push($(this).val());
    });

    return valoresSelecionados;  
}

function ResponderSubsidioSuplementoRemoneratorioEmMassa (resposta, periodo) {

    $.ajax({
        url: urlResposta + "?associado_ids=" + listaIds.join(',') + "&opcao=" + resposta + "&periodo=" + periodo,
        type: "get",
        dataType: "json",
        success: function (data) {
            console.log(data);

            if(data.status){
                document.getElementById('mensagens_sucesso').innerHTML = data.mensagem;
                acionarModal('ModalProcessoSucesso');
            }
            else{
                document.getElementById('mensagens_erro').innerHTML = data.mensagem;
                acionarModal('ModalProcessoERRO');
            }
        },
        error: function (data) {
            console.log(data);
        },
        beforeSend: function () {},
        complete: function () {},
    });
}

function acionarModal (modal) {
    console.log(modal);
    $(`#${modal}`).modal('show');
};

function actualizarPagina(){
    window.location.reload();
}

function formatarValor (valor) {
    return new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(valor);
}
