/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

function isValido(iban) {
    var prefixoIban = "AO06",
        mensagemErro = "",
        i = 0,
        tamanhoIban = iban.length;

    //1 regra - IBAN deve conter 25 caracteres
    if (tamanhoIban !== 25) {
        mensagemErro = "O IBAN deve conter exactamente 25 caracteres";
        apresentaMensagemErro(mensagemErro);
        return false;
    }

    //2 regra - IBAN deve começar com o prefixo AO06
    if (!iban.startsWith(prefixoIban)) {
        mensagemErro = "O IBAN deve conter o prefixo AO06";
        apresentaMensagemErro(mensagemErro);
        return false;
    }

    //3 regra - Depois do prefixo o IBAN deve conter só números
    for (i = 4; i < tamanhoIban; i++) {
        if (isNumero(iban.charAt(i)) === false) {
            mensagemErro = "Depois do prefixo AO06 só devem existir números";
            apresentaMensagemErro(mensagemErro);
            return false;
        }
    }

    removeMensagemErro();
    return true;
}

function isNumero(string) {
    var numeros = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0"];
    var valido = false;

    for (i = 0; i < numeros.length; i++) {
        if (string === numeros[i]) {
            return true;
        }
    }
    return false;
}

function apresentaMensagemErro(mensagem) {
    document.getElementById('alertaIban').style.visibility = "visible";
    document.getElementById("sms").innerHTML = mensagem;
}

function removeMensagemErro() {
    document.getElementById('alertaIban').style.visibility = "hidden";
}
