function checkPassword(element, event) {
    var pass = document.getElementById("password-input");
    var confirmPass = document.getElementById("confirm-password-input");
    var botao = document.getElementById("btnSubmite");

    if (event) {
        event.preventDefault();
    }

    if (pass.value !== confirmPass.value) {
        confirmPass.classList.add("is-invalid");
        pass.classList.add("is-invalid");
        botao.disabled = true; 
        return false;
    } else {
        confirmPass.classList.remove("is-invalid");
        pass.classList.remove("is-invalid");

        if (pass.value !== "" && confirmPass.value !== "") {
            botao.disabled = false;
        } else {
            botao.disabled = true;
        }
        return true;
    }
}

function validaPassword(element) {
    var botao = document.getElementById("btnSubmite");
    var confirmPass = document.getElementById("confirm-password-input");
    const conteiner = document.getElementById("password-contain");
    const password = element.value;

    const regexPassword = /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[!@#$%^&*(),.?":{}|<>])[a-zA-Z\d!@#$%^&*(),.?":{}|<>]{8,}$/;


    if (password.length === 0 || regexPassword.test(password) ) {
        conteiner.style.display = 'none';
        confirmPass.readOnly = false;
    } else {
        confirmPass.readOnly = true;
        conteiner.style.display = 'block';
    }

    // Verificar cada critério individualmente e atualizar as classes
    document.getElementById("pass-length").classList.toggle("valid", password.length >= 8);
    document.getElementById("pass-length").classList.toggle("required", password.length < 8);

    document.getElementById("pass-lower").classList.toggle("valid", /[a-z]/.test(password));
    document.getElementById("pass-lower").classList.toggle("required", !/[a-z]/.test(password));

    document.getElementById("pass-upper").classList.toggle("valid", /[A-Z]/.test(password));
    document.getElementById("pass-upper").classList.toggle("required", !/[A-Z]/.test(password));

    document.getElementById("pass-number").classList.toggle("valid", /\d/.test(password));
    document.getElementById("pass-number").classList.toggle("required", !/\d/.test(password));

    document.getElementById("pass-special").classList.toggle("valid", /[!@#$%^&*(),.?":{}|<>]/.test(password));
    document.getElementById("pass-special").classList.toggle("required", !/[!@#$%^&*(),.?":{}|<>]/.test(password));

    if (password === confirmPass.value && password !== "") {
        confirmPass.classList.remove("required");
        botao.disabled = false;
    } else {
        confirmPass.classList.add("required");
        botao.disabled = true;
    }
}

    
