function validarTexto(inputNome) {
    // const validaTextoComCaracteresEspeciais = /^[A-Za-zÀ-ÿ\u00f1\u00d1]+(?:[\s'-][A-Za-zÀ-ÿ\u00f1\u00d1]+)*$/;
    inputNome.onkeyup = function () {
        let nomeSemEspaco = inputNome.value.trim();

        if (nomeSemEspaco.length < 4) {
            inputNome.setCustomValidity(
                "Texto inválido ou quantidade de caracteres insuficiente (4 no minimo)"
            );
            inputNome.reportValidity();
        } else {
            inputNome.setCustomValidity("");
        }
    };
}

function validarTelefone(inputTel) {
    const validaNumTelefone = /^((\+244[9]{1}[0-9]{8})|(\+244[222]{3}[0-9]{6})|([9]{1}[0-9]{8})|([222]{3}[0-9]{6})|(\+\d{1,3}[1-9]\d{0,14}))$/;

    inputTel.onkeyup = function () {
        let telSemEspaco = inputTel.value.trim();

        if (!validaNumTelefone.test(telSemEspaco) || telSemEspaco.length < 9) {
            inputTel.setCustomValidity(
                "Número de Telefone inválido"
            );
            inputTel.reportValidity();
        } else {
            inputTel.setCustomValidity("");
        }
    };
}

function validarEmail(inputEmail) {
    const validaEmail = /^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*\.[a-zA-Z]{2,}$/;

    inputEmail.onkeyup = function () {
        if (!validaEmail.test(inputEmail.value)) {
            inputEmail.setCustomValidity("E-mail inválido...");
            inputEmail.reportValidity();
        } else {
            inputEmail.setCustomValidity("");
        }
    };
}


const emailGeral = document.getElementById("emailGeral");
const emailSuporte = document.getElementById("emailSuporte");
const endereco = document.getElementById("endereco");
const telefone = document.getElementById("telefone");
const latitude = document.getElementById("latitude");
const longitude = document.getElementById("longitude");

validarEmail(emailGeral);
validarEmail(emailSuporte);
validarTexto(endereco);
validarTelefone(telefone);

if (latitude && longitude) {
    latitude.onkeyup = function () {
        if (!/^-?\d+(\.\d+)?$/.test(latitude.value)) {
            latitude.setCustomValidity("Latitude inválida...");
            latitude.reportValidity();
        } else {
            latitude.setCustomValidity("");
        }
    };
    longitude.onkeyup = function () {
        if (!/^-?\d+(\.\d+)?$/.test(longitude.value)) {
            longitude.setCustomValidity("Longitude inválida...");
            longitude.reportValidity();
        } else {
            longitude.setCustomValidity("");
        }
    };
}