function validarTextoSemAcentos(inputNome) {
    const validaTextoComCaracteresEspeciais = /^(?:[A-Za-z]+|[A-Za-z][A-Za-z0-9]*)$/;

    inputNome.onkeyup = function () {
        let nomeSemEspaco = inputNome.value.trim();

        if (!validaTextoComCaracteresEspeciais.test(nomeSemEspaco) || nomeSemEspaco.length < 4) {
            inputNome.setCustomValidity(
                "Nome inválido"
            );
            inputNome.reportValidity();
        } else {
            inputNome.setCustomValidity("");
        }
    };
}

function validarTextoComAcentos(inputNome) {
    const validaTextoComCaracteresEspeciais = /^[A-Za-zÀ-ÿ\u00f1\u00d1]+(?:[\s'_][A-Za-zÀ-ÿ\u00f1\u00d1]+)*$/;

    inputNome.onkeyup = function () {
        let nomeSemEspaco = inputNome.value.trim();

        // if (!validaTextoComCaracteresEspeciais.test(nomeSemEspaco) || nomeSemEspaco.length < 4) {
        if (nomeSemEspaco.length < 4) {
            inputNome.setCustomValidity(
                "Descrição inválida"
            );
            inputNome.reportValidity();
        } else {
            inputNome.setCustomValidity("");
        }
    };
}


const nome = document.getElementById("nome");
const descricao = document.getElementById("descricao");

validarTextoSemAcentos(nome);
validarTextoComAcentos(descricao);

