function previewImage(event) {
    const file = event.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function (e) {
            document.getElementById('imagePreview').src = e.target.result;
        };
        reader.readAsDataURL(file);
    }
}

function validarEmail(inputEmail) {
    const validaEmail = /^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*\.[a-zA-Z]{2,}$/;

    inputEmail.onkeyup = function () {
        if (!validaEmail.test(inputEmail.value)) {
            inputEmail.setCustomValidity("E-mail inválido...");
            inputEmail.reportValidity();
        } else {
            inputEmail.setCustomValidity("");
        }
    };
}

function validarTextoComAcentos(inputNome) {
    const validaTextoComCaracteresEspeciais = /^[A-Za-zÀ-ÿ\u00f1\u00d1]+(?:[\s'-][A-Za-zÀ-ÿ\u00f1\u00d1]+)*$/;

    inputNome.onkeyup = function () {
        let nomeSemEspaco = inputNome.value.trim();

        if (!validaTextoComCaracteresEspeciais.test(nomeSemEspaco) || nomeSemEspaco.length < 5) {
            inputNome.setCustomValidity(
                "Nome inválido"
            );
            inputNome.reportValidity();
        } else {
            inputNome.setCustomValidity("");
        }
    };
}

function validarTextoSemAcentos(inputNome) {
    const validaTextoComCaracteresEspeciais = /^(?:[A-Za-z]+|[A-Za-z][A-Za-z0-9]*)$/;

    inputNome.onkeyup = function () {
        let nomeSemEspaco = inputNome.value.trim();

        if (!validaTextoComCaracteresEspeciais.test(nomeSemEspaco) || nomeSemEspaco.length < 5) {
            inputNome.setCustomValidity(
                "Nome inválido"
            );
            inputNome.reportValidity();
        } else {
            inputNome.setCustomValidity("");
        }
    };
}

function validarTelefone(inputTel) {
    const validaNumTelefone = /^((\+244[9]{1}[0-9]{8})|(\+244[222]{3}[0-9]{6})|([9]{1}[0-9]{8})|([222]{3}[0-9]{6})|(\+\d{1,3}[1-9]\d{0,14}))$/;

    inputTel.onkeyup = function () {
        let telSemEspaco = inputTel.value.trim();

        if (!validaNumTelefone.test(telSemEspaco) || telSemEspaco.length < 9) {
            inputTel.setCustomValidity(
                "Número de Telefone inválido"
            );
            inputTel.reportValidity();
        } else {
            inputTel.setCustomValidity("");
        }
    };
}


const nomeCompleto = document.getElementById("nomeCompleto");
const username = document.getElementById("username");
const email = document.getElementById("email");
const telefone = document.getElementById("telefone");

validarEmail(email);
validarTextoComAcentos(nomeCompleto);
validarTextoSemAcentos(username);
validarTelefone(telefone);

