///////////////////////////////////// EXPRESSOES //////////////////////////////////
const validaNumeroDoBIAngolano =
  /^[0-9]{9}(LA|BO|BA|BE|CA|CC|KN|KS|CE|HO|HA|LN|LS|ME|MO|NE|UE|ZE|OE|VP)[0-9]{3}$/;
const validaTextoComCaracteresEspeciais =
  /^[A-Za-zÀ-ÿ\u00f1\u00d1]+(?:[\s'-][A-Za-zÀ-ÿ\u00f1\u00d1]+)*$/;
const validaNumeroDaCedulaAngolana = /^\d{9,10}$/;
const validaNumeroDoPassaporteAngolano = /^[A-Z]{2}\d{7}$/;
const validaEmail = /^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*\.[a-zA-Z]{2,}$/;
const validaNumeroDeTelefone =
  /^((\+244[9]{1}[0-9]{8})|(\+244[222]{3}[0-9]{6})|([9]{1}[0-9]{8})|([222]{3}[0-9]{6})|(\+\d{1,3}[1-9]\d{0,14}))$/;
const validaNumeroMecanografico =  /^[a-zA-Z0-9]{5,15}$/

////////////////////////////////// Funcoes auxiliares //////////////////////////////////

// function validarNumeros(element) {
//   if (!validaNumeroMecanografico.test(element.value) || element.value.length < 5) {
//     element.setCustomValidity("O número Mecanografico deve ter no minimo 5 digitos!");
//     element.reportValidity();
//   } else {
//     element.setCustomValidity("");
//   }
// }

function formatarText(element) {
  let nomeSemEspaco = element.value.trim();
  if (nomeSemEspaco.length < 5) {
    element.setCustomValidity(" ");
    element.reportValidity();
  } else {
    element.setCustomValidity("");
  }
}


///////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////// VALIDACOES //////////////////////////////////

///////////////////////////// DADOS PESSOAIS /////////////////////////////////////////
const nome = document.getElementById("nome");
const n_mecanografico = document.getElementById("n_mecanografico");
const email = document.getElementById("email");
const telefone = document.getElementById("telefone");

nome.onkeyup = function () {
  let nomeSemEspaco = nome.value.trim();
  if (!validaTextoComCaracteresEspeciais.test(nomeSemEspaco) || nomeSemEspaco.length < 5) {
    nome.setCustomValidity("Informe um nome com 4 letras no minimo!");
    nome.reportValidity();
  } else {
    nome.setCustomValidity("");
  }
};

email.onkeyup = function () {
  if (!validaEmail.test(email.value.trim())) {
    email.setCustomValidity("E-mail inválido...");
    email.reportValidity();
  } else {
    email.setCustomValidity("");
  }
};

n_mecanografico.onkeyup = function () {
  let numeroSemEspaco = n_mecanografico.value.trim();
  if (!validaNumeroMecanografico.test(numeroSemEspaco) || numeroSemEspaco.length < 5) {
    n_mecanografico.setCustomValidity("O número Mecanografico deve ter no minimo 5 digitos!");
    n_mecanografico.reportValidity();
  } else {
    n_mecanografico.setCustomValidity("");
  }
};

telefone.onkeyup = function () {
  if (!validaNumeroDeTelefone.test(telefone.value)) {
    telefone.setCustomValidity("Informa um número de telefone válido...");
    telefone.reportValidity();
  } else {
    telefone.setCustomValidity("");
  }
};


///////////////////////// Validacao de ate 5 documentos //////////////////////////////////
///////////////////////// Documentos de Identificação - 1 //////////////////////////////////
const n_identificacao = document.getElementById("n_identificacao");
let validaNumeroDoDocumentoDeIdentificacao1 = ''

document.getElementById('tipo_documento').addEventListener('change', function () {
  // Obtém o valor selecionado do select

  const valorSelecionado = document.getElementById("tipo_documento").value;
  // Verifica o valor usando switch
   console.log(valorSelecionado)
  switch (valorSelecionado) {
    case "2":
      validaNumeroDoDocumentoDeIdentificacao1 = validaNumeroDoBIAngolano
      if (!validaNumeroDoDocumentoDeIdentificacao1.test(n_identificacao.value) && n_identificacao.value) {
        n_identificacao.setCustomValidity("O número do documento não corresponde ao tipo selecionado");
        n_identificacao.reportValidity();
      } else {
        n_identificacao.setCustomValidity("");
      }
      break;
    case "1":
      validaNumeroDoDocumentoDeIdentificacao1 = validaNumeroDaCedulaAngolana
      if (!validaNumeroDoDocumentoDeIdentificacao1.test(n_identificacao.value) && n_identificacao.value) {
        n_identificacao.setCustomValidity("O número do documento não corresponde ao tipo selecionado");
        n_identificacao.reportValidity();
      } else {
        n_identificacao.setCustomValidity("");
      }
      break;
    case "3":
      validaNumeroDoDocumentoDeIdentificacao1 = validaNumeroDoPassaporteAngolano
      if (!validaNumeroDoDocumentoDeIdentificacao1.test(n_identificacao.value) && n_identificacao.value) {
        n_identificacao.setCustomValidity("O número do documento não corresponde ao tipo selecionado");
        n_identificacao.reportValidity();
      } else {
        n_identificacao.setCustomValidity("");
      }
      break;
    default:
      validaNumeroDoDocumentoDeIdentificacao1 = validaTextoComCaracteresEspeciais
      console.log('Nenhum documento selecionado correspondente');
  }
});

n_identificacao.onkeyup = function () {
  if (!validaNumeroDoDocumentoDeIdentificacao1.test(n_identificacao.value.toUpperCase())) {
    n_identificacao.setCustomValidity("O número do documento não corresponde ao tipo! ");
    n_identificacao.reportValidity();
  } else {
    n_identificacao.setCustomValidity("");
  }
};
