@extends('admin.layouts.platform')

@section('title', 'Legislação')

@section('subtitle','Editar')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Documentos Legislativos</span></li>
                    <li><span>Editar</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        <!-- start: page -->
        @if ($errors->any())
            <script>
                Swal.fire({
                    title: 'AVISO',
                    icon: 'warning',
                    html: `
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    `,
                    confirmButtonText: 'Fechar'
                });
            </script>
        @endif

        <div class="row" style="padding-top: 80px;">
            <form action="{{ route('legislacoes.update', $legislacao->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <div class="card-actions"></div>
                            <h2 class="card-title">Editar Documento Legislativo</h2>
                        </header>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="row">
                                        <!-- Campo Título -->
                                        <div class="col-lg-6 mb-3">
                                            <div class="form-group">
                                                <label class="col-form-label" for="titulo">Título</label>
                                                <input type="text" class="form-control" id="titulo" name="titulo" 
                                                       value="{{ $legislacao->titulo ?? '' }}" 
                                                       placeholder="Digite o título" required>
                                            </div>
                                        </div>
        
                                        <!-- Campo Subtítulo -->
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label class="col-form-label" for="subtitulo">Subtítulo</label>
                                                <input type="text" class="form-control" id="subtitulo" name="subtitulo" 
                                                       value="{{ $legislacao->subTitulo ?? '' }}" 
                                                       placeholder="Digite o subtítulo">
                                            </div>
                                        </div>
        
                                        <!-- Campo Estado -->
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label class="col-form-label" for="estado">Estado</label>
                                                <select class="form-control" id="estado" name="estado" required>
                                                    <option value="" disabled>Selecione o estado</option>
                                                    <option value="1" {{ $legislacao->estado == '1' ? 'selected' : '' }}>Ativo</option>
                                                    <option value="0" {{ $legislacao->estado == '0' ? 'selected' : '' }}>Inativo</option>
                                                </select>
                                            </div>
                                        </div>
        
                                        <!-- Campo Documento -->
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label class="col-form-label" for="documento">Documento</label>
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" id="documento" name="documento" accept=".pdf">
                                                    <div>
                                                        <label class="custom-file-label" for="documento">
                                                            {{ $legislacao->anexo ? 'Substituir o documento existente' : 'Selecione um arquivo de até 10MB...' }}
                                                        </label>
                                                    </div>
                                                </div>
                                                @if ($legislacao->anexo)
                                                    <p class="mt-2">
                                                        Documento atual: 
                                                        <a href="{{ asset('admin/documentos/legislacao/' . $legislacao->anexo) }}" download>
                                                            {{ $legislacao->anexo }}
                                                        </a>
                                                    </p>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <footer class="card-footer text-end">
                            <a href="{{ route('legislacoes.index') }}" class="btn btn-dark">Voltar</a>
                            <button type="submit" class="btn btn-warning">Salvar Alterações</button>
                        </footer>
                    </section>
                </div>
            </form>
        </div>
        
        
        <!-- end: page -->
    </section>
    <script src="{{ asset("admin/js/Validacao/legislacao.js")}}"></script>
@endsection

    