@extends('admin.layouts.platform')

@section('title', 'Logs Gerais')

@section('subtitle','Listagem')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Auditória</span></li>
                    <li><span>Logs</span></li>
                    <li><span>Gerais</span></li>
                    <li><span>Listagem</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        <!-- start: page -->
        <div class="row" style="padding-top: 80px;">
            <div class="col">
                <section class="card">
                    <header class="card-header">
                        <div class="card-actions">
                            {{-- <a href="#" class="card-action card-action-toggle" data-card-toggle></a> --}}
                        </div>
                        <h2 class="card-title">Listagem de Logs Gerais</h2>
                    </header>
                    <div class="card-body">
                        {{-- <div class="row">
                            <div class="col-sm-6">
                                <div class="mb-3">
                                </div>
                            </div>
                        </div> --}}
                        <table class="table table-bordered table-striped mb-0" id="datatable-tabletools">
                            <thead>
                                {{-- <a id="addToTable" class="btn btn-dark" href="{{ route('utilizadors.create')}}">Adicionar Novo Utilizador <i class="fas fa-plus"></i></a> --}}
                                <tr>
                                    <th>#</th>
                                    <th>Alteração</th>
                                    <th>Operação</th>
                                    <th>Utilizador</th>
                                    <th>Perfil</th>
                                    <th>Data</th>
                                    <th>Acção</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($logs as $log)
                                    <tr>
                                        <td>{{ $loop->index +1 }}</td>
                                        <td>{{ $log->auditable_type ?? '' }}</td>
                                        @if ($log->evento == 'updated')
                                            <td>{{ 'Actualização' }}</td>
                                        @elseif ($log->evento == 'created')
                                            <td>{{ 'Inserção' }}</td>
                                        @elseif ($log->evento == 'deleted')
                                            <td>{{ 'Delete' }}</td>
                                        @endif
                                        <td>{{ $log->users->name_completo ?? 'Sistema' }}</td>
                                        <td>{{ $log->users->role->name ?? 'Sistema' }}</td>
                                        <td>{{ $log->data_registo ?? ''}}</td>
                                        <td class="actions">
                                            <a href="{{ route('auditoria-geral.show', encrypt($log->id))}}"><i class="fa-solid fa-eye"></i></a>                                           
                                        </td>
                                    </tr>   
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>

        <!-- end: page -->
    </section>
@endsection

    

@section('javascript')


@endsection