@extends('admin.layouts.platform')

@section('title', 'Benefícios')

@section('subtitle','Registro')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>DASHBOARD</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Benefícios</span></li>
                <li><span>Registro</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>
    @if ($errors->any())
        <script>
            Swal.fire({
                title: 'AVISO',
                icon: 'warning',
                html: `
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                `,
                confirmButtonText: 'Fechar'
            });
        </script>
    @endif

    <!-- start: page -->
    <div class="row" style="padding-top: 80px;">
        <form action="{{ route('beneficio.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="col-lg-12">
                <section class="card">
                    <header class="card-header">
                        <h2 class="card-title">Registro de Benefício</h2>
                    </header>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="row">
                                    <div class="col-lg-12 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="nomeCompleto">Benefício</label>
                                            <input type="text" class="form-control" id="beneficio" maxlength="250" name="beneficio" placeholder="Digite o Benefício" required>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="username">Descrição</label>
                                            <input type="text" class="form-control" id="descricao" maxlength="250" name="descricao" placeholder="Digite a Descrição">
                                        </div>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for="estado" class="col-form-label">Estado</label>
                                        <select class="form-select" id="estado" name="estado" required>
                                            <option value="" disabled selected>Selecione o estado</option>
                                            <option value="1">Activo</option>
                                            <option value="0">Inativo</option>
                                        </select>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <div class="form-group">
                                            <label class="col-form-label" for="perfil">Categoria de Benefício</label>
                                            <select id="categoria" name="categoria" class="form-control" title="Por favor, selecione a categoria" required>
                                                <option selected disabled value="">Selecione uma categoria</option>
                                                @foreach ($categoriasBeneficios as $categoria)
                                                    <option value="{{ $categoria->id }}">{{ $categoria->nome }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <footer class="card-footer text-end">
                        <a href="{{ route('beneficio.index') }}" class="btn btn-dark">Voltar</a>
                        <button type="submit" class="btn btn-warning">Submeter</button>
                    </footer>
                </section>
            </div>
        </form>
    </div>
</section>

<script src="{{ asset("admin/js/Validacao/beneficio.js")}}"></script>
@endsection