@extends('admin.layouts.platform')

@section('title', 'Categoria de Benefícios')

@section('subtitle','Registro')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Configurações</span></li>
                    <li><span>Categoria de Benefícios</span></li>
                    <li><span>Registro</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        <!-- start: page -->
        @if ($errors->any())
            <script>
                Swal.fire({
                    title: 'AVISO',
                    icon: 'warning',
                    html: `
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    `,
                    confirmButtonText: 'Fechar'
                });
            </script>
        @endif

        <div class="row" style="padding-top: 80px;">
            <form action="{{ route('categoria-de-beneficio.store')}}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <div class="card-actions">
                                {{-- <a href="#" class="card-action card-action-toggle" data-card-toggle></a>
                                <a href="#" class="card-action card-action-dismiss" data-card-dismiss></a> --}}
                            </div>
                            <h2 class="card-title">Registro de Categoria de Benefícios</h2>
                        </header>
                        <div class="card-body">
                            <div class="row">            
                                <!-- Coluna dos Inputs -->
                                <div class="col-lg-12">
                                    <div class="row">
                                        <div class="col-lg-8 mb-3">
                                            <div class="form-group">
                                                <label class="col-form-label" for="nome">Nome da Categoria</label>
                                                <input type="text" class="form-control" id="nome" name="nome" placeholder="Digite o nome da categoria" required>
                                            </div>
                                        </div>
                                        
                                        <div class="col-lg-4 mb-3">
                                            <label for="estado" class="col-form-label">Estado</label>
                                            <select class="form-select" id="estado" name="estado" required>
                                                <option value="" disabled selected>Selecione o estado</option>
                                                <option value="1">Activo</option>
                                                <option value="0">Inativo</option>
                                            </select>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                        <footer class="card-footer text-end">
                            <a href="{{ route('categoria-de-beneficio.index') }}" class="btn btn-dark">Voltar</a>
                            <button class="btn btn-warning">Submeter</button>
                        </footer>
                    </section>
                </div>
            </form>
        </div>

        <!-- end: page -->
    </section>
    <script src="{{ asset("admin/js/Validacao/categoriaBeneficio.js")}}"></script>
@endsection

    
