@extends('admin.layouts.platform')

@section('title', 'Categoria de Parceiros')

@section('subtitle','Detalhes')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header">
        <h2>DASHBOARD</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin') }}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Configurações</span></li>
                <li><span>Categoria de Parceiros</span></li>
                <li><span>Detalhes</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>
    <!-- start: page -->
    <div class="row" style="padding-top: 80px;">
        <div class="col-lg-12">
            <section class="card">
                <header class="card-header">
                    <h2 class="card-title">Detalhes da Categoria de Parceiros</h2>
                </header>

                <div class="card-body">
                    <div class="row">            
                        <!-- Coluna dos Inputs -->
                        <div class="col-lg-12">
                            <div class="row">
                                <div class="col-lg-6 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="nome">Nome da Categoria</label>
                                        <input type="text" class="form-control" id="nome" name="nome" value="{{ $categoria->nome ?? ''}}" placeholder="Digite o nome da categoria" readonly>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 mb-3">
                                    <div class="form-group">
                                        <label class="col-form-label" for="estado">Estado</label>
                                        <input type="text" class="form-control" id="estado" name="estado" value="{{ $categoria->estado ? 'Activo' : 'Inativo'}}" placeholder="Digite o estado" readonly>
                                    </div>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                </div>
                <footer class="card-footer text-end">
                    <a href="{{ route('categoria-de-parceiro.index') }}" class="btn btn-dark">Voltar</a>
                    <a href="{{ route('categoria-de-parceiro.edit', encrypt($categoria->id)) }}" class="btn btn-warning">Editar</a>
                </footer>
            </section>
        </div>
    </div>
    <!-- end: page -->
</section>
@endsection
