@extends('admin.layouts.platform')

@section('title', 'Entidade Acesso e Permissões')
@section('subtitle','Configurações Visuais e Gerais')

@section('conteudo')
<section role="main" class="content-body">
    <header class="page-header" >
        <h2>Configurações Visuais e Gerais</h2>
        <div class="right-wrapper text-end">
            <ol class="breadcrumbs">
                <li>
                    <a href="{{ route('admin')}}">
                        <i class="bx bx-home-alt"></i>
                    </a>
                </li>
                <li><span>Inicio</span></li>
                <li><span>Configurações</span></li>
                <li><span>Entidade</span></li>
                <li><span>App Config</span></li>
                <li><span>Acessos</span></li>
            </ol>
            <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
        </div>
    </header>

    @if ($errors->any())
        <script>
            Swal.fire({
                title: 'AVISO',
                icon: 'warning',
                html: `<ul>@foreach ($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>`,
                confirmButtonText: 'Fechar'
            });
        </script>
    @endif

    @if (session('success'))
        <script>
            Swal.fire({
                title: 'Sucesso',
                icon:'success',
                text: '{{ session('success') }}',
                confirmButtonText: 'Fechar'
            })
        </script>
    @endif

    <div style="padding-top: 80px;">
        <form method="POST"  action="{{route('admin.config.appConfig.add')}}" enctype="multipart/form-data">
            @csrf
            <div class="row">
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <h2 class="card-title">Configuração Geral do Portal</h2>
                        </header>
                        <div class="card-body">
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <label>Nome do Portal</label>
                                    <input name="portal_nome" class="form-control" value="{{ old('portal_nome', $config->portal_nome ?? '') }}">
                                </div>
                                <div class="col-md-6">
                                    <label>Nome da Aplicação Complementar</label>
                                    <input name="olimpo_app_nome" class="form-control" value="{{ old('olimpo_app_nome', $config->olimpo_app_nome ?? '') }}">
                                </div>
                            </div>
                            <div class="row mb-4">
                                <div class="col-md-12">
                                    <label>CopyRight Portal</label>
                                    <input name="copyright" class="form-control" value="{{ old('copyright', $config->copyright ?? '') }}">
                                </div>
                            </div>
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <label>Cor Secundária - Texto</label>
                                    <div class="d-flex align-items-center gap-2">
                                        <input type="color" id="primary_color" name="primary_color" class="form-control form-control-color" value="{{ old('primary_color', $config->primary_color ?? '') }}">
                                        <div id="preview_primary" style="width: 40px; height: 40px; border-radius: 5px; border: 1px solid #ccc; background-color: {{ old('primary_color', $config->primary_color ?? '#000000') }};"></div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label>Cor Secundária</label>
                                    <div class="d-flex align-items-center gap-2">
                                        <input type="color" id="secondary_color" name="secondary_color" class="form-control form-control-color" value="{{ old('secondary_color', $config->secondary_color ?? '#ffffff') }}">
                                        <div id="preview_secondary" style="width: 40px; height: 40px; border-radius: 5px; border: 1px solid #ccc; background-color: {{ old('secondary_color', $config->secondary_color ?? '#ffffff') }};"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <label>Shortcut Icon</label>
                                    <input type="file" name="shortcut_icon" accept="image/jpeg,image/jpg,image/png" class="form-control">
                                </div>
                            </div>
                            <h4>Meta Dados</h4>
                            <div class="border rounded p-3 mb-3">
                                 <div class="row g-2">
                                    <div class="col-md-6">
                                        <label>keywords (Palavras Chaves)</label>
                                        <input name="keywords" value="{{ $config->meta_dados['keywords'] ?? '' }}" class="form-control" placeholder="Keywords">
                                    </div>
                                    <div class="col-md-6">
                                        <label>Author (Autor)</label>
                                        <input name="author" value="{{ $config->meta_dados['author'] ?? '' }}" class="form-control" placeholder="Author">
                                    </div>
                                    <div class="col-md-12">
                                        <label>Description (Descrição)</label>
                                        <input name="description" value="{{ $config->meta_dados['description'] ?? '' }}" class="form-control" placeholder="Description">
                                    </div>
                                </div>
                            </div>
                            {{-- <hr> --}}
                             {{-- Menu e Submenus --}}
                            <h4>Itens do Menu</h4>
                            <div id="menu-items">
                                @foreach($config->menu_items ?? [] as $i => $item)
                                    <div class="border rounded p-3 mb-3" data-idx="{{ $i }}">
                                        <div class="row g-2">
                                            <div class="col-md-4">
                                                <input name="menu_conf[{{ $i }}][title]" class="form-control" placeholder="Texto" value="{{ $item['title'] ?? '' }}">
                                            </div>
                                            <div class="col-md-4">
                                                <input name="menu_conf[{{ $i }}][route]" class="form-control" placeholder="Rota" value="{{ $item['route'] ?? '' }}">
                                            </div>
                                            <div class="col-md-2">
                                                <input name="menu_conf[{{ $i }}][icon]" class="form-control" placeholder="Ícone" value="{{ $item['icon'] ?? '' }}">
                                            </div>
                                            <div class="col-md-2">
                                                <select name="menu_conf[{{ $i }}][visible]" class="form-control">
                                                    <option value="1" {{ ($item['visible'] ?? true) ? 'selected' : '' }}>Visível</option>
                                                    <option value="0" {{ !($item['visible'] ?? true) ? 'selected' : '' }}>Oculto</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div id="children-{{ $i }}" class="ms-4 mt-3">
                                            @foreach($item['children'] ?? [] as $ci => $child)
                                                <div class="row g-2 mb-2">
                                                    <div class="col-md-5">
                                                        <input name="menu_conf[{{ $i }}][children][{{ $ci }}][title]" class="form-control" placeholder="Submenu Texto" value="{{ $child['title'] ?? '' }}">
                                                    </div>
                                                    <div class="col-md-5">
                                                        <input name="menu_conf[{{ $i }}][children][{{ $ci }}][route]" class="form-control" placeholder="Submenu Rota" value="{{ $child['route'] ?? '' }}">
                                                    </div>
                                                    <div class="col-md-2">
                                                        <select name="menu_conf[{{ $i }}][children][{{ $ci }}][visible]" class="form-control">
                                                            <option value="1" {{ ($child['visible'] ?? true) ? 'selected' : '' }}>Visível</option>
                                                            <option value="0" {{ !($child['visible'] ?? true) ? 'selected' : '' }}>Oculto</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                        <button type="button" class="btn btn-sm btn-outline-primary mt-2 add-submenu" data-parent="{{ $i }}">+ Submenu</button>
                                    </div>
                                @endforeach
                            </div>
                            <button type="button" class="btn btn-info" id="add-menu-item">Adicionar Item ao Menu</button>

                            <hr>
                            <h4>Rodapé - Redes Sociais</h4>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="mostrar_redes_links" value="1" id="show_social_links" {{ old('mostrar_redes_links', $config->mostrar_redes_links ?? false) ? 'checked' : '' }}>
                                <label class="form-check-label" for="show_social_links">
                                    Mostrar redes sociais no rodapé
                                </label>
                            </div>
                            <div id="social-links">
                                @foreach($config->redes_links ?? [] as $i => $link)
                                    <div class="row border rounded p-3 mb-3">
                                        <div class="col-md-5">
                                            <input name="redes_links[{{ $i }}][platform]" value="{{ $link['platform'] ?? '' }}" class="form-control" placeholder="Plataforma (ex: Facebook)">
                                        </div>
                                        <div class="col-md-5">
                                            <input name="redes_links[{{ $i }}][url]" value="{{ $link['url'] ?? '' }}" class="form-control" placeholder="URL">
                                        </div>
                                        <div class="col-md-2">
                                            <select name="redes_links[{{ $i }}][visible]" class="form-control">
                                                <option value="1" {{ $link['visible'] ? 'selected' : '' }}>Visível</option>
                                                <option value="0" {{ !$link['visible'] ? 'selected' : '' }}>Oculto</option>
                                            </select>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <button type="button" class="btn btn-info" id="add-social-link">Adicionar Rede Social</button>
                        </div>

                        <footer class="card-footer text-end">
                            {{-- <a href="{{ route('admin') }}" class="btn btn-dark">Voltar</a> --}}
                            <button class="btn btn-warning">Salvar</button>
                        </footer>
                    </section>
                </div>
            </div>
        </form>
    </div>
</section>

<script>
    let menuIndex = {{ count($config->menu_items ?? []) }};
    let socialIndex = {{ count($config->social_links ?? []) }};
    const menuContainer=document.getElementById('menu-items');

    document.getElementById('add-menu-item').addEventListener('click',()=>{
        menuContainer.insertAdjacentHTML('beforeend', menuItemTemplate(menuIndex));
        menuIndex++;
    });

    menuContainer.addEventListener('click',e=>{
        if(e.target.classList.contains('add-submenu')){
            const parentIdx=e.target.dataset.parent;
            const childrenWrap=document.getElementById(`children-${parentIdx}`);
            let childIdx=childrenWrap.childElementCount;
            childrenWrap.insertAdjacentHTML('beforeend',submenuTemplate(parentIdx,childIdx));
        }
    });

    function menuItemTemplate(idx){
        return `<div class="border rounded p-3 mb-3" data-idx="${idx}">`
            +`<div class="row g-2">
                <div class="col-md-4"><input name="menu_conf[${idx}][title]" class="form-control" placeholder="Texto"></div>
                <div class="col-md-4"><input name="menu_conf[${idx}][route]" class="form-control" placeholder="Rota (vazio se tiver submenus)"></div>
                <div class="col-md-2"><input name="menu_conf[${idx}][icon]" class="form-control" placeholder="Ícone"></div>
                <div class="col-md-2">
                    <select name="menu_conf[${idx}][visible]" class="form-control"><option value="1">Visível</option><option value="0">Oculto</option></select>
                </div>
            </div>`
            +`<div id="children-${idx}" class="ms-4 mt-3"></div>
            <button type="button" class="btn btn-sm btn-outline-primary mt-2 add-submenu" data-parent="${idx}">+ Submenu</button>
        </div>`;
    }

    function submenuTemplate(parentIdx,childIdx){
        return `<div class="row g-2 mb-2">
            <div class="col-md-5"><input name="menu_conf[${parentIdx}][children][${childIdx}][title]" class="form-control" placeholder="Submenu Texto"></div>
            <div class="col-md-5"><input name="menu_conf[${parentIdx}][children][${childIdx}][route]" class="form-control" placeholder="Submenu Rota"></div>
            <div class="col-md-2">
                <select name="menu_conf[${parentIdx}][children][${childIdx}][visible]" class="form-control"><option value="1">Visível</option><option value="0">Oculto</option></select>
            </div>
        </div>`;
    }

    document.getElementById('add-social-link').addEventListener('click', function () {
        const container = document.getElementById('social-links');
        const html = `
        <div class="row border rounded p-3 mb-3">
            <div class="col-md-5">
                <input name="redes_links[\${socialIndex}][platform]" class="form-control" placeholder="Plataforma">
            </div>
            <div class="col-md-5">
                <input name="redes_links[\${socialIndex}][url]" class="form-control" placeholder="URL">
            </div>
            <div class="col-md-2">
                <select name="redes_links[\${socialIndex}][visible]" class="form-control">
                    <option value="1">Visível</option>
                    <option value="0">Oculto</option>
                </select>
            </div>
        </div>`;
        container.insertAdjacentHTML('beforeend', html);
        socialIndex++;
    });

    document.getElementById('primary_color').addEventListener('input', function () {
        document.getElementById('preview_primary').style.backgroundColor = this.value;
    });

    document.getElementById('secondary_color').addEventListener('input', function () {
        document.getElementById('preview_secondary').style.backgroundColor = this.value;
    });
</script>
@endsection


