@extends('admin.layouts.platform')

@section('title', 'Notificações')

@section('subtitle','Update')

@section('conteudo')
    <section role="main" class="content-body" >
        <header class="page-header" >
            <h2>DASHBOARD</h2>
            <div class="right-wrapper text-end">
                <ol class="breadcrumbs">
                    <li>
                        <a href="{{ route('admin')}}">
                            <i class="bx bx-home-alt"></i>
                        </a>
                    </li>
                    <li><span>Inicio</span></li>
                    <li><span>Configurações</span></li>
                    <li><span>Entidade</span></li>
                    <li><span>App-Notification</span></li>
                    <li><span>Views</span></li>
                </ol>
                <a class="sidebar-right-toggle" data-open="sidebar-right"><i class="fas fa-chevron-left"></i></a>
            </div>
        </header>
        <!-- start: page -->
        @if ($errors->any())
            <script>
                Swal.fire({
                    title: 'AVISO',
                    icon: 'warning',
                    html: `
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    `,
                    confirmButtonText: 'Fechar'
                });
            </script>
        @endif

        @if (session('success'))
            <script>
                Swal.fire({
                    title: 'Sucesso',
                    icon:'success',
                    text: '{{ session('success') }}',
                    confirmButtonText: 'Fechar'
                })
            </script>
        @endif

        <div class="row" style="padding-top: 80px;">
            <form action="{{ route('sys-notificacoes.store')}}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <div class="card-actions">
                                {{-- <a href="#" class="card-action card-action-toggle" data-card-toggle></a>
                                <a href="#" class="card-action card-action-dismiss" data-card-dismiss></a> --}}
                            </div>
                            <h2 class="card-title">Configurações de Notificações</h2>
                            {{-- <p class="card-subtitle">
                                Este é um exemplo de formulário com múltiplos campos organizados em colunas.
                            </p> --}}
                        </header>

                        <div class="card-body">
                            <div class="row">
                                <!-- Coluna dos Inputs -->
                                <div class="col-md-6">
                                    <label for="estado" class="form-label">Notificar Por</label>
                                    <select class="form-control"  id="estado" name="tipo" required>
                                        <option value="" disabled {{ old('tipo', $notificacao->tipo) == null ? 'selected' : '' }}>Selecione a forma de notificação</option>
                                        <option value="2" {{ old('tipo', $notificacao->tipo == 2)  ? 'selected' : '' }}>Emails</option>
                                        <option value="1" {{ old('tipo', $notificacao->tipo == 1)  ? 'selected' : '' }}>Mensagens</option>
                                        {{-- <option value="3" {{ old('tipo', $notificacao->tipo == 3)  ? 'selected' : '' }}>Emails & Mensagens</option> --}}
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label" for="numero-mecanografico-input">Descrição</label>
                                    <input type="text" class="form-control"
                                        placeholder="Informe a descricao" name="descricao" value="{{ $notificacao->descricao ?? old('descricao') }}" >
                                    <div class="invalid-feedback">Por favor, preencha o cargo</div>
                                </div>

                                <span class="mt-4" style="color: red">Nota: Aqui, Configura-se o metodo de notificação que será utilizado pelo sistema, por Padrão o Sistema utilizará o Serviço de mensagens</span>
                                                           
                            </div>
                        </div>

                        <footer class="card-footer text-end">
                            {{-- <a href="{{ route('sys-notificacoes.create') }}" class="btn btn-dark">Voltar</a> --}}
                            <button class="btn btn-warning">Submeter</button>
                        </footer>
                    </section>
                </div>
            </form>
        </div>

        <!-- end: page -->
    </section>
@endsection